/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItemId;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoItemDTO;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DevolucaoCreditoItemService
extends CrudService<DevolucaoCreditoItem, DevolucaoCreditoItemId> {
    private final CreditoService creditoService;
    private final PagamentoService pagamentoService;

    public Page<DevolucaoCreditoItemDTO> getPagamentosCreditoParaDevolucoes(String search, Pageable pageable) {
        Page pagamentos = this.creditoService.findByRsql(search, pageable);
        return pagamentos.map(DevolucaoCreditoItemDTO::from);
    }

    public Page<DevolucaoCreditoItemDTO> getPagamentosParaDevolucoes(String search, Pageable pageable) {
        Page pagamentos = this.pagamentoService.findPagamentosParaEstorno(search, pageable);
        return pagamentos.map(DevolucaoCreditoItemDTO::from);
    }

    public DevolucaoCreditoItemDTO getDevolucaoCreditoItemDTOToDevolucao(PagamentoId id) {
        DevolucaoCreditoItemDTO dto = this.getPagamentoCreditoParaDevolucao(id);
        if (Objects.isNull(dto)) {
            dto = this.getPagamentoParaDevolucao(id);
        }
        if (Objects.isNull(dto)) {
            throw new EloValidationException("Nenhum pagamento ou cr\u00e9dito encontrado para o ID: " + id);
        }
        return dto;
    }

    public DevolucaoCreditoItemDTO getPagamentoParaDevolucao(PagamentoId id) {
        return this.pagamentoService.findById((Serializable)id).map(DevolucaoCreditoItemDTO::from).orElse(null);
    }

    public DevolucaoCreditoItemDTO getPagamentoCreditoParaDevolucao(PagamentoId id) {
        return this.creditoService.findOptionalByPagamentoId(id).map(DevolucaoCreditoItemDTO::from).orElse(null);
    }

    public boolean pagamentoIsRefundable(PagamentoId id) {
        Pagamento pagamento = (Pagamento)this.pagamentoService.findById((Serializable)id).orElseThrow(() -> new EloValidationException("Pagamento n\u00e3o encontrado: " + id));
        if (Boolean.TRUE.equals(pagamento.isDevolvidoTotal())) {
            return false;
        }
        if (this.creditoService.findOptionalByPagamentoId(id).isPresent()) {
            return true;
        }
        return Boolean.FALSE.equals(pagamento.isEstornado());
    }

    @Generated
    public DevolucaoCreditoItemService(CreditoService creditoService, PagamentoService pagamentoService) {
        this.creditoService = creditoService;
        this.pagamentoService = pagamentoService;
    }
}

