/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.SituacaoDevolucaoCredito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebitoId;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItemId;
import br.com.elotech.tributos.repository.DevolucaoCreditoDebitoRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DevolucaoCreditoDebitoService
extends CrudService<DevolucaoCreditoDebito, DevolucaoCreditoDebitoId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DevolucaoCreditoDebitoService.class);
    private final DevolucaoCreditoDebitoRepository repository;
    private static final int SCALE_PRECISION = 2;

    public BigDecimal findAllValorDevolvido(DebitoParcelaTributo debitoParcelaTributo) {
        List devolucoes = this.getDevolucoesByDebitoParcelaTributo(debitoParcelaTributo);
        return devolucoes.stream().filter(arg_0 -> this.isDevolucaoDevolvida(arg_0)).map(DevolucaoCreditoDebito::getValorDevolvido).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_EVEN);
    }

    private List<DevolucaoCreditoDebito> getDevolucoesByDebitoParcelaTributo(DebitoParcelaTributo debitoParcelaTributo) {
        return this.repository.findDevolucaoCreditoDebitoByDebitoParcelaTributo(debitoParcelaTributo).orElse(Collections.emptyList());
    }

    private boolean isDevolucaoDevolvida(DevolucaoCreditoDebito devolucao) {
        return Optional.ofNullable(devolucao.getId()).map(DevolucaoCreditoDebitoId::getDevolucaoCreditoItem).map(DevolucaoCreditoItem::getId).map(DevolucaoCreditoItemId::getDevolucaoCredito).map(DevolucaoCredito::getSituacao).filter(arg_0 -> SituacaoDevolucaoCredito.DEVOLVIDO.equals(arg_0)).isPresent();
    }

    @Generated
    public DevolucaoCreditoDebitoService(DevolucaoCreditoDebitoRepository repository) {
        this.repository = repository;
    }
}

