/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItem;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemA;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemE;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZ;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoArquivoItemDTO;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import br.com.elotech.tributos.exception.DebitoAutomaticoException;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ConvenioRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.batch.debitoautomatico.ImportacaoArquivoDebitoAutomaticoJobStarter;
import br.com.elotech.tributos.service.batch.debitoautomatico.RemessaArquivoDebitoAutomaticoJobStarter;
import br.com.elotech.tributos.util.FieldUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DebitoAutomaticoRemessaService
extends CrudService<DebitoAutomaticoRemessa, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebitoAutomaticoRemessaService.class);
    private static final Long CODIGO_REMESSA = 1L;
    private static final String MOEDA_REAL = "03";
    private static final Long CODIGO_MOVIMENTO = 0L;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository;
    private final ImportacaoArquivoDebitoAutomaticoJobStarter importacaoArquivoDebitoAutomaticoJobStarter;
    private final RemessaArquivoDebitoAutomaticoJobStarter remessaArquivoDebitoAutomaticoJobStarter;
    private final BancoRepository bancoRepository;
    private final ConvenioRepository convenioRepository;
    private final EntidadeService entidadeService;
    private final ContextService contextService;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void importarArquivos(List<MultipartFile> arquivos) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        for (MultipartFile arquivo : arquivos) {
            ArquivoDTO retornoS3 = this.salvarArquivoNoS3(arquivo);
            Long idArquivo = retornoS3.getId();
            String nomeArquivo = retornoS3.getNome();
            this.importacaoArquivoDebitoAutomaticoJobStarter.startJob(idArquivo, nomeArquivo);
        }
    }

    public ArquivoDTO salvarArquivoNoS3(MultipartFile arquivo) {
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, arquivo.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/importacao-debito-automatico", LocalDate.now(), "text/plain", null, null, null);
        return this.arquivoStorageFeignClient.createWithFile(arquivoDTO, arquivo);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void gerarRemessa(RemessaDebitoAutomaticoFilterDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        Convenio convenio;
        Long totalItens = this.debitoAutomaticoRemessaRepository.totalItensParaGerar(filtro);
        if (totalItens.compareTo(0L) == 0) {
            throw new DebitoAutomaticoException("N\u00e3o h\u00e1 itens para gerar com o filtro informado");
        }
        convenio.setSequenciaArquivoEnvio(Long.valueOf(Objects.isNull((convenio = this.convenioRepository.findByConvenio(filtro.getConvenio())).getSequenciaArquivoEnvio()) ? 0L : convenio.getSequenciaArquivoEnvio() + 1L));
        convenio = (Convenio)this.convenioRepository.saveAndFlush((Object)convenio);
        DebitoAutomaticoRemessa remessa = new DebitoAutomaticoRemessa();
        remessa.setId(convenio.getSequenciaArquivoEnvio());
        remessa.setEntidade(this.contextService.getEntidadePrincipal());
        remessa.setDataEmissao(LocalDate.now());
        remessa.setExercicio(Long.valueOf(remessa.getDataEmissao().getYear()));
        remessa = (DebitoAutomaticoRemessa)this.debitoAutomaticoRemessaRepository.save((Object)remessa);
        this.debitoAutomaticoRemessaRepository.flush();
        this.remessaArquivoDebitoAutomaticoJobStarter.startJob(remessa.getId(), filtro);
    }

    public byte[] gerarArquivo(Long idRemessa) throws IOException {
        EntidadeInfo entidadeInfo = this.entidadeService.findEntidadePrincipal();
        ArrayList<Object> itensDoArquivo = new ArrayList<Object>();
        List itensDaRemessa = this.debitoAutomaticoRemessaRepository.findItensArquivoRemessa(idRemessa);
        Banco banco = (Banco)this.bancoRepository.findOne((Object)((RemessaDebitoAutomaticoArquivoItemDTO)itensDaRemessa.get(0)).getBanco());
        Convenio convenio = this.convenioRepository.findByConvenio(((RemessaDebitoAutomaticoArquivoItemDTO)itensDaRemessa.get(0)).getConvenio());
        ADAItemA adaItemA = new ADAItemA();
        adaItemA.setCodigoRemessa(CODIGO_REMESSA);
        adaItemA.setCodigoConvenio(convenio.getNumeroConvenio());
        adaItemA.setNomeEmpresa(entidadeInfo.getDescricao());
        adaItemA.setCodigoBanco(banco.getId());
        adaItemA.setNomeBanco(banco.getDescricao());
        adaItemA.setDataGeracao(LocalDate.now());
        adaItemA.setNsa(idRemessa);
        adaItemA.setVersaoLayout(Long.valueOf(4L));
        adaItemA.setIdentificacaoServico("DEBITO AUTOMATICO");
        adaItemA.setReservado("");
        itensDoArquivo.add(adaItemA);
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (RemessaDebitoAutomaticoArquivoItemDTO item : itensDaRemessa) {
            ADAItemE adaItemE = new ADAItemE();
            adaItemE.setIdentificacaoClienteEmpresa(item.getClienteEmpresa());
            adaItemE.setAgenciaDebito(item.getAgencia());
            adaItemE.setIdentificacaoClienteBanco(item.getIdentificacao());
            adaItemE.setDataVencimento(item.getDataVencimento());
            adaItemE.setValorDebito(item.getValor());
            adaItemE.setCodigoMoeda(MOEDA_REAL);
            adaItemE.setUsuEmpresa(item.getUsoDaEmpresa());
            adaItemE.setTipoIdentificacao("");
            adaItemE.setIdentificacao("");
            adaItemE.setReservado("");
            adaItemE.setCodigoMovimento(CODIGO_MOVIMENTO);
            itensDoArquivo.add(adaItemE);
            valorTotal = valorTotal.add(item.getValor());
        }
        ADAItemZ adaItemZ = new ADAItemZ();
        adaItemZ.setTotalRegistros(Long.valueOf((long)itensDaRemessa.size() + 2L));
        adaItemZ.setValorTotal(valorTotal);
        adaItemZ.setReservado("");
        itensDoArquivo.add(adaItemZ);
        File tempFile = File.createTempFile("temp", ".rem");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            for (ADAItem aDAItem : itensDoArquivo) {
                writer.write(FieldUtils.getString((Object)aDAItem));
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Files.readAllBytes(tempFile.toPath());
    }

    @Generated
    public DebitoAutomaticoRemessaService(ArquivoStorageFeignClient arquivoStorageFeignClient, DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository, ImportacaoArquivoDebitoAutomaticoJobStarter importacaoArquivoDebitoAutomaticoJobStarter, RemessaArquivoDebitoAutomaticoJobStarter remessaArquivoDebitoAutomaticoJobStarter, BancoRepository bancoRepository, ConvenioRepository convenioRepository, EntidadeService entidadeService, ContextService contextService) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.debitoAutomaticoRemessaRepository = debitoAutomaticoRemessaRepository;
        this.importacaoArquivoDebitoAutomaticoJobStarter = importacaoArquivoDebitoAutomaticoJobStarter;
        this.remessaArquivoDebitoAutomaticoJobStarter = remessaArquivoDebitoAutomaticoJobStarter;
        this.bancoRepository = bancoRepository;
        this.convenioRepository = convenioRepository;
        this.entidadeService = entidadeService;
        this.contextService = contextService;
    }
}

