/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfiguracaoInscricaoCadastralService
extends CrudService<ConfiguracaoInscricaoCadastral, Long> {
    private static final Long CONFIGURACAO_ID = 1L;
    private static final String TABLE_NAME = "tribcadastroimobiliario";
    private static final String COLUMN_NAME = "inscricaocadastral";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    @Autowired
    private DataSource dataSource;

    public ConfiguracaoInscricaoCadastral getConfiguracao() {
        return (ConfiguracaoInscricaoCadastral)this.getRepository().findById((Object)CONFIGURACAO_ID).orElseThrow(() -> new EloValidationException("As configura\u00e7\u00f5es da Inscri\u00e7\u00e3o Cadastral est\u00e3o inv\u00e1lidas"));
    }

    public Integer getInscricaoCadastralColumnSize() {
        int columnSize = -1;
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaName = connection.getSchema();
            try (ResultSet columns = metaData.getColumns(null, schemaName, TABLE_NAME, COLUMN_NAME);){
                if (columns.next()) {
                    columnSize = columns.getInt(COLUMN_SIZE);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Erro ao obter o tamanho da coluna: " + e.getMessage(), e);
        }
        return columnSize;
    }
}

