/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.CancelamentoBoletoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import java.io.Serializable;
import org.springframework.stereotype.Service;

@Service
public class CancelamentoBoletoEstornoParcelamentoService {
    private final BloquetoService bloquetoService;
    private final CancelamentoBoletoService cancelamentoBoletoService;
    private final ParcelamentoService parcelamentoService;

    public CancelamentoBoletoEstornoParcelamentoService(BloquetoService bloquetoService, CancelamentoBoletoService cancelamentoBoletoService, ParcelamentoService parcelamentoService) {
        this.bloquetoService = bloquetoService;
        this.cancelamentoBoletoService = cancelamentoBoletoService;
        this.parcelamentoService = parcelamentoService;
    }

    public void cancelamentoBoletoPorEstornoParcelamento(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)idParcelamento);
        if (Boolean.TRUE.equals(parcelamento.getEstornado())) {
            UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
            this.cancelamentoBoletoService.cancelarBoletoId(this.bloquetoService.findByIdParcelamento(idParcelamento), user);
        }
    }
}

