/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.TipoValidadeDocumento;
import br.com.elotech.tributos.exception.DocumentoValidadeException;
import java.time.LocalDate;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CalculaValidadeDocumentoService {
    public LocalDate calculaDataValidade(DocumentoTipo tipoDocumento, DocumentoFinalidade documentoFinalidade) {
        if (TipoValidadeDocumento.POR_TIPO_DOCUMENTO.equals((Object)tipoDocumento.getValidade())) {
            return this.getDataValidade(tipoDocumento.getValidadeDia(), tipoDocumento.getValidadeData());
        }
        if (TipoValidadeDocumento.POR_FINALIDADE.equals((Object)tipoDocumento.getValidade())) {
            if (Objects.isNull(documentoFinalidade)) {
                throw new DocumentoValidadeException(HttpStatus.BAD_REQUEST, "Finalidade n\u00e3o configurada no tipo de documento");
            }
            return this.getDataValidade(documentoFinalidade.getValidadeDia(), documentoFinalidade.getValidadeData());
        }
        return null;
    }

    private LocalDate getDataValidade(Integer validadeDia, LocalDate validadeData) {
        LocalDate dataEmissao = LocalDate.now();
        if (Objects.nonNull(validadeDia)) {
            return dataEmissao.plusDays(validadeDia.intValue());
        }
        if (Objects.nonNull(validadeData)) {
            return validadeData;
        }
        throw new DocumentoValidadeException(HttpStatus.BAD_REQUEST, "Validade do tipo documento n\u00e3o configurado");
    }
}

