/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Cbo;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioProfissionalDTO;
import br.com.elotech.tributos.dto.ProfissionalDTO;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepository;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioProfissionalRepository;
import br.com.elotech.tributos.service.CboService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class CadastroMobiliarioProfissionalService
extends CrudService<CadastroMobiliarioProfissional, Long> {
    private final MobiliarioProfissionalRepository mobiliarioProfissionalRepository;
    private final CadastroMobiliarioRepository cadastroMobiliarioRepository;
    private final PessoaRepository pessoaRepository;
    private final CboService cboService;

    public void saveProfissionaisEmCadastroMobiliario(CadastroMobiliario cadastroMobiliarioToSave, List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais) {
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioRepository.saveAndFlush((Object)cadastroMobiliarioToSave);
        cadastroMobiliario.getCadastroMobiliarioProfissionais().addAll(this.adjustAndSaveProfissionais(cadastroMobiliarioProfissionais, cadastroMobiliario));
    }

    private List<CadastroMobiliarioProfissional> adjustAndSaveProfissionais(List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais, CadastroMobiliario cadastroMobiliario) {
        cadastroMobiliarioProfissionais.forEach(profissional -> {
            profissional.setCadastroGeral(cadastroMobiliario.getCadastroGeral());
            profissional.setCadastroMobiliario(cadastroMobiliario);
        });
        return this.mobiliarioProfissionalRepository.saveAll(cadastroMobiliarioProfissionais);
    }

    public List<CadastroMobiliarioProfissional> mappingProfissionaisDtoToEntity(CadastroMobiliarioDTO cadastroMobiliarioDTO, CadastroMobiliario cadastroMobiliario) {
        return cadastroMobiliarioDTO.getProfissionais().stream().map(dto -> {
            CadastroMobiliarioProfissional entity = this.fromCadastroMobiliarioProfissionalDtoToEntity(dto, cadastroMobiliario);
            return Objects.isNull(entity.getId()) && Objects.isNull(cadastroMobiliario.getCadastroGeral()) ? entity : (CadastroMobiliarioProfissional)this.mobiliarioProfissionalRepository.save((Object)entity);
        }).collect(Collectors.toList());
    }

    public void removeProfissionaisFromCadastroMobiliario(Long id, List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais) {
        CadastroMobiliario cadastroMobiliarioFound = this.findCadastroMobiliarioById(id);
        List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionaisToRemove = cadastroMobiliarioProfissionais.isEmpty() ? cadastroMobiliarioFound.getCadastroMobiliarioProfissionais() : cadastroMobiliarioFound.getCadastroMobiliarioProfissionais().stream().filter(profissional -> cadastroMobiliarioProfissionais.stream().noneMatch(profissionalDTO -> Objects.nonNull(profissionalDTO.getId()) && profissionalDTO.getId().equals(profissional.getId()))).collect(Collectors.toList());
        cadastroMobiliarioProfissionaisToRemove.forEach(arg_0 -> ((MobiliarioProfissionalRepository)this.mobiliarioProfissionalRepository).delete(arg_0));
    }

    private CadastroMobiliario findCadastroMobiliarioById(Long id) {
        return (CadastroMobiliario)this.cadastroMobiliarioRepository.findById((Object)id).orElseThrow(() -> new EntityExistsException(String.format("Cadastro mobili\u00e1rio com o id %d n\u00e3o encontrado.", id)));
    }

    public void createCadastroMobiliarioProfissionalDTO(CadastroMobiliarioDTO cadastroMobiliarioDTO, List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais) {
        for (CadastroMobiliarioProfissional profissional : cadastroMobiliarioProfissionais) {
            CadastroMobiliarioProfissionalDTO dto = new CadastroMobiliarioProfissionalDTO();
            dto.setId(profissional.getId());
            dto.setProfissional(ProfissionalDTO.from((Pessoa)((Pessoa)this.pessoaRepository.findOne((Object)profissional.getProfissional()))));
            dto.setCbo(Objects.nonNull(profissional.getCbo()) ? (Cbo)this.cboService.findOne((Serializable)profissional.getCbo()) : null);
            cadastroMobiliarioDTO.getProfissionais().add(dto);
        }
    }

    private CadastroMobiliarioProfissional fromCadastroMobiliarioProfissionalDtoToEntity(CadastroMobiliarioProfissionalDTO dto, CadastroMobiliario cadastroMobiliario) {
        CadastroMobiliarioProfissional cadastroMobiliarioProfissional = new CadastroMobiliarioProfissional();
        cadastroMobiliarioProfissional.setId(dto.getId());
        cadastroMobiliarioProfissional.setCbo(dto.getCbo().getId());
        cadastroMobiliarioProfissional.setProfissional(dto.getProfissional().getId());
        cadastroMobiliarioProfissional.setCadastroMobiliario(cadastroMobiliario);
        cadastroMobiliarioProfissional.setTipoCadastro(cadastroMobiliario.getTipoCadastro());
        cadastroMobiliarioProfissional.setCadastroGeral(cadastroMobiliario.getCadastroGeral());
        return cadastroMobiliarioProfissional;
    }

    public void ajustarProfissionaisEmCadastroMobiliario(CadastroMobiliarioDTO cadastroMobiliarioDTO, CadastroMobiliario cadastroMobiliario) {
        cadastroMobiliario.getCadastroMobiliarioProfissionais().addAll(this.mappingProfissionaisDtoToEntity(cadastroMobiliarioDTO, cadastroMobiliario));
        this.removeProfissionaisFromCadastroMobiliario(cadastroMobiliario.getId(), cadastroMobiliario.getCadastroMobiliarioProfissionais());
    }

    @Generated
    public CadastroMobiliarioProfissionalService(MobiliarioProfissionalRepository mobiliarioProfissionalRepository, CadastroMobiliarioRepository cadastroMobiliarioRepository, PessoaRepository pessoaRepository, CboService cboService) {
        this.mobiliarioProfissionalRepository = mobiliarioProfissionalRepository;
        this.cadastroMobiliarioRepository = cadastroMobiliarioRepository;
        this.pessoaRepository = pessoaRepository;
        this.cboService = cboService;
    }
}

