/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDTO;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ValidaEmissaoBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class BoletoEspecialService {
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final ValidaEmissaoBoletoService validaEmissaoBoletoService;

    public BoletoEspecialDTO getInitialValues(List<DebitoEmAbertoDTO> debitosSelecionados) {
        if (debitosSelecionados.isEmpty()) {
            throw new EloValidationException("\u00c9 necess\u00e1rio escolher pelo menos um d\u00e9bito para gerar o boleto especial.");
        }
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List debitos = this.calculoAcrescimoService.calculaAcrescimos(this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro(debitosSelecionados), Boolean.TRUE), formaPagamentoPadrao.getId());
        this.validaEmissaoBoletoService.podeEmitirBoleto(debitos, Boolean.valueOf(false), Boolean.valueOf(true));
        return BoletoEspecialDTO.from((List)debitos);
    }

    private String mountFiltro(List<DebitoEmAbertoDTO> debitosSelecionados) {
        return debitosSelecionados.stream().map(debitoEmAbertoDTO -> {
            if (Objects.nonNull(debitoEmAbertoDTO.getIdParcelamento())) {
                return String.format("(tribDebitoParcelaReceita.parcela = %d and tribDebito.idparcelamento = %d)", debitoEmAbertoDTO.getParcela(), debitoEmAbertoDTO.getIdParcelamento());
            }
            return String.format("(tribDebitoParcelaReceita.entidade = %d and tribDebitoParcelaReceita.exercicio = %d and tribDebitoParcelaReceita.tipocadastro = %d and tribDebitoParcelaReceita.cadastrogeral = %d and tribDebitoParcelaReceita.guiarecolhimento = %d and tribDebitoParcelaReceita.subdivida = %d and tribDebitoParcelaReceita.parcela = %d)", debitoEmAbertoDTO.getEntidade(), debitoEmAbertoDTO.getExercicio(), debitoEmAbertoDTO.getTipoCadastro(), debitoEmAbertoDTO.getCadastroGeral(), debitoEmAbertoDTO.getDivida(), debitoEmAbertoDTO.getSubDivida(), debitoEmAbertoDTO.getParcela());
        }).collect(Collectors.joining(" or "));
    }

    @Generated
    public BoletoEspecialService(FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, DebitoEmAbertoService debitoEmAbertoService, ValidaEmissaoBoletoService validaEmissaoBoletoService) {
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.validaEmissaoBoletoService = validaEmissaoBoletoService;
    }
}

