/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.dto.BoletoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.BoletoDebitoTributoDTO;
import br.com.elotech.tributos.repository.BoletoDebitoRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BoletoDebitoService
extends ReadOnlyService<BoletoDebito, BoletoDebitoID> {
    private final BoletoDebitoRepository boletoDebitoRepository;

    public BoletoDebitoService(BoletoDebitoRepository boletoDebitoRepository) {
        this.boletoDebitoRepository = boletoDebitoRepository;
    }

    public List<BoletoDebitoTributoDTO> findByIdBoleto(Long id) {
        return this.boletoDebitoRepository.findBoletoDebito(id).stream().map(BoletoDebitoTributoDTO::from).collect(Collectors.toList());
    }

    public List<BoletoDebitoParcelaDTO> findDebitosPorParcelaByIdBoleto(Long id) {
        Map<BoletoDebitoParcelaDTO, List<BoletoDebito>> agrupado = this.boletoDebitoRepository.findBoletoDebito(id).stream().collect(Collectors.groupingBy(BoletoDebitoParcelaDTO::fromWithoutValue));
        ArrayList<BoletoDebitoParcelaDTO> itens = new ArrayList<BoletoDebitoParcelaDTO>();
        agrupado.forEach((key, boletoDebitos) -> itens.add(boletoDebitos.stream().map(BoletoDebitoParcelaDTO::from).reduce((BoletoDebitoParcelaDTO)key, (acumulator, item) -> {
            acumulator.setValorPrincipal(acumulator.getValorPrincipal().add(item.getValorPrincipal()));
            acumulator.setValorJuros(acumulator.getValorJuros().add(item.getValorJuros()));
            acumulator.setValorMulta(acumulator.getValorMulta().add(item.getValorMulta()));
            acumulator.setValorCorrecao(acumulator.getValorCorrecao().add(item.getValorCorrecao()));
            acumulator.setValorDesconto(acumulator.getValorDesconto().add(item.getValorDesconto()));
            return acumulator;
        })));
        itens.sort(Comparator.comparing(BoletoDebitoParcelaDTO::getTipoCadastro).thenComparing(BoletoDebitoParcelaDTO::getCadastroGeral).thenComparing(BoletoDebitoParcelaDTO::getExercicio).thenComparing(BoletoDebitoParcelaDTO::getDivida).thenComparing(BoletoDebitoParcelaDTO::getSubDivida).thenComparing(BoletoDebitoParcelaDTO::getParcela));
        return itens;
    }

    public List<BoletoDebitoTributoDTO> findComAcrescimosByIdBoleto(Long id) {
        return this.boletoDebitoRepository.findBoletoDebito(id).stream().map(BoletoDebitoTributoDTO::from).collect(Collectors.toList());
    }
}

