/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.domain.Tenant;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class AsyncTenantFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTenantFilter.class);
    private TenantClient tenantClient;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!TenantContextHolder.hasTenant()) {
            String tenantId = this.getTenantId((HttpServletRequest)request);
            Tenant tenant = (Tenant)this.tenantClient.getTenant(tenantId).orElseThrow();
            TenantContextHolder.setTenant((Tenant)tenant);
        }
        chain.doFilter(request, response);
    }

    private String getTenantId(HttpServletRequest request) {
        String host = StringUtils.defaultIfBlank((String)request.getHeader("X-FORWARDED-HOST"), (String)request.getServerName());
        if (!"localhost".equalsIgnoreCase(host) && !host.startsWith("localhost:")) {
            return StringUtils.substringBefore((String)host, (String)".").toLowerCase(Locale.getDefault());
        }
        log.debug("Aplica\u00e7\u00e3o rodando no ambiente de desenvolvimento: {}", (Object)host);
        return this.tenantClient.getDefaultTenant();
    }

    @Generated
    public AsyncTenantFilter(TenantClient tenantClient) {
        this.tenantClient = tenantClient;
    }
}

