/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.transferenciadebito;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebito;
import br.com.elotech.tributos.dto.transferenciadebito.FiltroTDDebitoParcelaDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitoParcelaDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitosParcelasCheckedDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TranferirDebitoDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TransferenciaDebitoDTO;
import br.com.elotech.tributos.service.transferenciadebito.TransferenciaDebitoService;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/transferencia-debito"})
public class TransferenciaDebitoResource
extends CrudResource<TransferenciaDebito, Long> {
    private final TransferenciaDebitoService transferenciaDebitoService;

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<TransferenciaDebitoDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page page = Objects.requireNonNull((Page)this.findAll(search, pageable).getBody());
        return ResponseEntity.ok((Object)page.map(TransferenciaDebitoDTO::fromWithoutDebitos));
    }

    @GetMapping(value={"/dto/{id}"})
    public ResponseEntity<TransferenciaDebitoDTO> findOneDTO(@PathVariable(value="id") Long id) {
        TransferenciaDebito found = Objects.requireNonNull((TransferenciaDebito)this.findOne((Serializable)id).getBody());
        return ResponseEntity.ok((Object)TransferenciaDebitoDTO.from((TransferenciaDebito)found));
    }

    @PostMapping(value={"/debitos-parcelas"})
    public ResponseEntity<Page<TDDebitoParcelaDTO>> findDebitosParcelas(@Valid @RequestBody FiltroTDDebitoParcelaDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.transferenciaDebitoService.findDebitosParcelas(filtro, pageable));
    }

    @PostMapping(value={"/debitos-parcelas-to-check-all"})
    public ResponseEntity<TDDebitosParcelasCheckedDTO> findDebitosParcelasToCheckAll(@Valid @RequestBody FiltroTDDebitoParcelaDTO filtro) {
        return ResponseEntity.ok((Object)this.transferenciaDebitoService.findDebitosParcelasToCheckAll(filtro));
    }

    @PostMapping(value={"/transferir"})
    public ResponseEntity<TransferenciaDebitoDTO> transferir(@Valid @RequestBody TranferirDebitoDTO dto) {
        TransferenciaDebito transferencia = this.transferenciaDebitoService.transferir(dto);
        return ResponseEntity.ok((Object)TransferenciaDebitoDTO.fromWithoutDebitos((TransferenciaDebito)transferencia));
    }

    @Generated
    public TransferenciaDebitoResource(TransferenciaDebitoService transferenciaDebitoService) {
        this.transferenciaDebitoService = transferenciaDebitoService;
    }
}

