/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.supersimples.dassenda;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivo;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoCalculoDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoDTO;
import br.com.elotech.tributos.service.supersimples.dassenda.DassendaArquivoService;
import br.com.elotech.tributos.service.supersimples.dassenda.ImportacaoArquivoDassendaJobStarter;
import br.com.elotech.tributos.service.supersimples.dassenda.VerificacaoArquivoDassendaJobStarter;
import java.io.IOException;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dassenda-arquivos"})
public class DassendaArquivoResource {
    private final DassendaArquivoService service;
    private final ImportacaoArquivoDassendaJobStarter importacaoArquivoDassendaJobStarter;
    private final VerificacaoArquivoDassendaJobStarter verificacaoArquivoDassendaJobStarter;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DassendaArquivoDTO> findOne(@PathVariable(value="id") Long id) {
        return this.service.findById((Serializable)id).map(DassendaArquivoDTO::from).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @GetMapping
    public ResponseEntity<Page<DassendaArquivoDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page dassendaArquivos = this.service.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)dassendaArquivos.map(DassendaArquivoDTO::from));
    }

    @PostMapping(value={"/importar"})
    public ResponseEntity<DassendaArquivoDTO> importar(@RequestParam MultipartFile file) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        DassendaArquivo dassendaArquivo = this.service.validateAndSaveArquivo(file);
        this.importacaoArquivoDassendaJobStarter.startJob(dassendaArquivo);
        return ResponseEntity.ok((Object)DassendaArquivoDTO.from((DassendaArquivo)dassendaArquivo));
    }

    @PostMapping(value={"/{id}/calculo/verificar-lote"})
    public ResponseEntity<Void> verificarCalculosLote(@PathVariable(value="id") Long id) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.verificacaoArquivoDassendaJobStarter.startJob(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/calculo/{idCalculo}/verificar"})
    public ResponseEntity<Void> verificarCalculo(@PathVariable(value="idCalculo") Long idCalculo) {
        this.service.findCalculoAndVerificar(idCalculo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/calculo"})
    public ResponseEntity<Page<DassendaArquivoCalculoDTO>> searchCalculos(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.searchCalculos(id, search, pageable));
    }

    @GetMapping(value={"/calculo/{id}"})
    public ResponseEntity<DassendaArquivoCalculoDTO> findCalculoById(@PathVariable(value="id") Long id) {
        return this.service.findCalculoById(id).map(DassendaArquivoCalculoDTO::new).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @Generated
    public DassendaArquivoResource(DassendaArquivoService service, ImportacaoArquivoDassendaJobStarter importacaoArquivoDassendaJobStarter, VerificacaoArquivoDassendaJobStarter verificacaoArquivoDassendaJobStarter) {
        this.service = service;
        this.importacaoArquivoDassendaJobStarter = importacaoArquivoDassendaJobStarter;
        this.verificacaoArquivoDassendaJobStarter = verificacaoArquivoDassendaJobStarter;
    }
}

