/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.sisobra;

import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.FiltroSisObraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoHistoricoDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraHistoricoDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.TipoAlvara;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.sisobra.SisObraAlteraSituacaoService;
import br.com.elotech.tributos.service.sisobra.SisObraAlvaraService;
import br.com.elotech.tributos.service.sisobra.SisObraDSMService;
import br.com.elotech.tributos.service.sisobra.SisObraHabiteseService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sisobra"})
public class SisObraResource {
    private final SisObraAlvaraService sisObraAlvaraService;
    private final SisObraHabiteseService sisObraHabiteseService;
    private final SisObraAlteraSituacaoService sisObraAlteraSituacaoService;
    private final SisObraDSMService sisObraDSMService;

    @GetMapping(path={"/alvara/documentos"})
    public ResponseEntity<Page<SisObraAlvaraDTO>> findDocumentoSisObraAlvara(FiltroSisObraDTO filtro, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraAlvaraService.findDocumentoSisObraAlvara(filtro, pageable));
    }

    @GetMapping(path={"/habite-se/documentos"})
    public ResponseEntity<Page<SisObraHabiteseDTO>> findDocumentoSisObraHabitese(FiltroSisObraDTO filtro, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraHabiteseService.findDocumentoSisObraHabitese(filtro, pageable));
    }

    @GetMapping(path={"/alteraSituacao/documentos"})
    public ResponseEntity<Page<SisObraAlteraSituacaoDTO>> findDocumentoSisObraCancelamento(FiltroSisObraDTO filtro, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraAlteraSituacaoService.findDocumentoSisObraAlteraSituacao(filtro, pageable));
    }

    @PostMapping(path={"/alvara/enviar"})
    public ResponseEntity enviarDocumentosSisObraAlvara(@RequestBody List<SisObraAlvaraDTO> alvaras) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.sisObraAlvaraService.gravarDados(alvaras, TipoAlvara.INICIAL, user);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(path={"/habite-se/enviar"})
    public ResponseEntity enviarDocumentosSisObraHabitese(@RequestBody List<SisObraHabiteseDTO> habiteses) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.sisObraHabiteseService.gravarDados(habiteses, user);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(path={"/alteraSituacao/enviar"})
    public ResponseEntity enviarDocumentosSisObraAlteraSituacao(@RequestBody List<SisObraAlteraSituacaoDTO> documentos) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.sisObraAlteraSituacaoService.gravarDados(documentos, user);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(path={"/dsm/enviar"})
    public ResponseEntity enviarDeclaracaoSemMovimento() {
        this.sisObraDSMService.enviarDeclaracaoSemMovimentos();
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @GetMapping(path={"/alvara/historico/{id}"})
    public ResponseEntity<Page<SisObraAlvaraHistoricoDTO>> getHistoricoAlvara(@PathVariable(value="id") Long id, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraAlvaraService.findHistoricoAlvara(id, pageable));
    }

    @GetMapping(path={"/habite-se/historico/{id}"})
    public ResponseEntity<Page<SisObraHabiteseHistoricoDTO>> getHistoricoHabitese(@PathVariable(value="id") Long id, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraHabiteseService.findHistoricoHabitese(id, pageable));
    }

    @GetMapping(path={"/alteraSituacao/historico/{id}"})
    public ResponseEntity<Page<SisObraAlteraSituacaoHistoricoDTO>> getHistoricoAlteraSituacao(@PathVariable(value="id") Long id, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.sisObraAlteraSituacaoService.findHistoricoAlteraSituacao(id, pageable));
    }

    @Generated
    public SisObraResource(SisObraAlvaraService sisObraAlvaraService, SisObraHabiteseService sisObraHabiteseService, SisObraAlteraSituacaoService sisObraAlteraSituacaoService, SisObraDSMService sisObraDSMService) {
        this.sisObraAlvaraService = sisObraAlvaraService;
        this.sisObraHabiteseService = sisObraHabiteseService;
        this.sisObraAlteraSituacaoService = sisObraAlteraSituacaoService;
        this.sisObraDSMService = sisObraDSMService;
    }
}

