/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.rocada;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.dto.comunicado.GerarComunicadoRequest;
import br.com.elotech.tributos.dto.rocada.GerarComunicadoRocadaRequestDTO;
import br.com.elotech.tributos.dto.rocada.RocadaDTO;
import br.com.elotech.tributos.dto.rocada.RocadaResumoImobiliarioDTO;
import br.com.elotech.tributos.service.comunicado.GerarComunicadoManualService;
import br.com.elotech.tributos.service.rocada.RocadaService;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rocadas"})
public class RocadaResource {
    private final RocadaService rocadaService;
    private final GerarComunicadoManualService gerarComunicadoManualService;

    @GetMapping(value={"/{entidade}/{exercicio}/{idRocada}"})
    public ResponseEntity<RocadaDTO> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idRocada) {
        return this.rocadaService.findById(entidade, exercicio, idRocada).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<RocadaDTO>> search(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.rocadaService.search(search, pageable).map(RocadaDTO::from));
    }

    @PostMapping
    public ResponseEntity<RocadaDTO> save(@RequestBody @Valid RocadaDTO rocadaDTO) {
        return ResponseEntity.ok((Object)this.rocadaService.save(rocadaDTO));
    }

    @DeleteMapping(value={"/{entidade}/{exercicio}/{idRocada}"})
    public ResponseEntity<Void> delete(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idRocada) {
        this.rocadaService.delete(entidade, exercicio, idRocada);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{idRocada}/gerar-debito"})
    public ResponseEntity<Void> generateDebitoAndBoletoAsync(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idRocada) {
        this.rocadaService.generateDebitoAndBoletoAsync(entidade, exercicio, idRocada);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/gerar-comunicado"})
    public ResponseEntity<Void> generateComunicadoByRocada(@RequestBody GerarComunicadoRocadaRequestDTO dto) {
        GerarComunicadoRequest request = this.rocadaService.buildGerarComunicadoRequest(dto);
        Comunicado comunicado = this.gerarComunicadoManualService.gerarComunicadoManual(request);
        this.rocadaService.saveComunicado(dto.getEntidade(), dto.getExercicio(), dto.getIdRocada(), comunicado);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/resumo-imobiliario"})
    public ResponseEntity<RocadaResumoImobiliarioDTO> processResumoImobiliario(@RequestBody @Valid RocadaResumoImobiliarioDTO requestDTO) {
        RocadaResumoImobiliarioDTO dto = this.rocadaService.processResumoImobiliario(requestDTO);
        return ResponseEntity.ok((Object)dto);
    }

    @Generated
    public RocadaResource(RocadaService rocadaService, GerarComunicadoManualService gerarComunicadoManualService) {
        this.rocadaService = rocadaService;
        this.gerarComunicadoManualService = gerarComunicadoManualService;
    }
}

