/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.dto.integracaoelogeo.CondominioElogeoDTO;
import br.com.elotech.tributos.service.CondominioService;
import io.swagger.v3.oas.annotations.Operation;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/condominio"})
public class CondominioElogeoResource {
    private final CondominioService condominioService;

    public CondominioElogeoResource(CondominioService condominioService) {
        this.condominioService = condominioService;
    }

    @Operation(summary="Retorna uma lista de condom\u00ednios")
    @GetMapping
    public ResponseEntity<Page<CondominioElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page condominios = this.condominioService.findAll(page).map(CondominioElogeoDTO::from);
        return ResponseEntity.ok((Object)condominios);
    }

    @Operation(summary="Retorna um condom\u00ednio em espec\u00edfico")
    @GetMapping(value={"/{condominio}"})
    public ResponseEntity<CondominioElogeoDTO> findByCondominio(@PathVariable Long condominio) {
        return ResponseEntity.ok((Object)CondominioElogeoDTO.from((Condominio)this.condominioService.findByCondominio(condominio)));
    }
}

