/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.dto.integracaoelogeo.CadastroMobiliarioElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroMobiliarioElogeo;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro/mobiliario"})
public class CadastroMobiliarioElogeoResource {
    private final CadastroMobiliarioElogeo CadastroMobiliarioElogeo;

    public CadastroMobiliarioElogeoResource(CadastroMobiliarioElogeo cadastroMobiliarioElogeo) {
        this.CadastroMobiliarioElogeo = cadastroMobiliarioElogeo;
    }

    @Operation(summary="Retorna um cadastro Mobili\u00e1rio em espec\u00edfico")
    @GetMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroMobiliarioElogeoDTO> findByCadastroGeralElogeoDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.CadastroMobiliarioElogeo.findByCadastroGeralElogeoDTO(cadastroGeral));
    }

    @Operation(summary="Retorna uma lista de cadastro mobili\u00e1rio alterados no p\u00e9riodo informado")
    @GetMapping(value={"/alterados"})
    public ResponseEntity<List<CadastroMobiliarioElogeoDTO>> findCadastroGeralAlteradosElogeoDTO(@RequestParam(value="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(value="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        return ResponseEntity.ok((Object)this.CadastroMobiliarioElogeo.findCadastroGeralAlteradosElogeoDTO(dataInicial, dataFinal));
    }

    @Operation(summary="Retorna uma lista de cadastro mobili\u00e1rio cadastrados no p\u00e9riodo informado")
    @GetMapping(value={"/novos"})
    public ResponseEntity<List<CadastroMobiliarioElogeoDTO>> findCadastroGeralNovosElogeoDTO(@RequestParam(value="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(value="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        return ResponseEntity.ok((Object)this.CadastroMobiliarioElogeo.findCadastroGeralNovosElogeoDTO(dataInicial, dataFinal));
    }
}

