/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.dto.ArrecadacaoPorDadosCadastraisFiltros;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorDadosCadastraisResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoPorDadosCadastraisService;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/arrecadacao-por-dados-cadastrais"})
public class ArrecadacaoPorDadosCadastraisResource {
    private final ArrecadacaoPorDadosCadastraisService service;

    @PostMapping(value={"/consulta"})
    public ResponseEntity<ArrecadacaoPorDadosCadastraisResumoDTO> consultar(@RequestBody ArrecadacaoPorDadosCadastraisFiltros filtros, Pageable pageable) {
        ArrecadacaoPorDadosCadastraisResumoDTO resumo = this.service.consultaByFiltro(filtros, pageable);
        return ResponseEntity.ok((Object)resumo);
    }

    @PostMapping(value={"/consulta/tributo/{tipocadastro}/{cadastrogeral}"})
    public ResponseEntity<List<ArrecadacaoPorTributoValoresDTO>> consultarTributoPorCadastro(@PathVariable(value="tipocadastro") Long tipoCadastro, @PathVariable(value="cadastrogeral") Long cadastroGeral, @RequestBody ArrecadacaoPorDadosCadastraisFiltros filtros) {
        return ResponseEntity.ok((Object)this.service.consultaTributosByCadastro(tipoCadastro, cadastroGeral, filtros));
    }

    @PostMapping(value={"/imprimir"})
    public ResponseEntity<byte[]> printInScreenArrecadacaoPorDadosCadastrais(@RequestBody @Valid ArrecadacaoPorDadosCadastraisFiltros filtro, @RequestParam(value="reportType") String reportType, Pageable pageable) throws Throwable {
        String contentType;
        byte[] arquivo = this.service.imprimirResumoArrecadacaoPorDadosCadastrais(filtro, pageable, reportType);
        String fileExtension = Objects.equals(reportType, "PDF") ? "pdf" : "csv";
        String string = contentType = Objects.equals(reportType, "PDF") ? "application/pdf" : "text/csv";
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o relatorio de arrecada\u00e7\u00e3o por tributos.");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)contentType));
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename("arrecadacao-por-tributo." + fileExtension).build());
        headers.setContentLength((long)arquivo.length);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)arquivo);
    }

    @Generated
    public ArrecadacaoPorDadosCadastraisResource(ArrecadacaoPorDadosCadastraisService service) {
        this.service = service;
    }
}

