/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.protesto;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.GerarProtestoRemessaDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.LoteBatchInstanceDTO;
import br.com.elotech.tributos.dto.ProtestoDTO;
import br.com.elotech.tributos.dto.documento.GeracaoDocumentoSimplificadoRequest;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaTituloDTO;
import br.com.elotech.tributos.params.FileProtestoParams;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.batch.protesto.GerarProtestoRemessaJobStarter;
import br.com.elotech.tributos.service.documento.DocumentoProtestoService;
import br.com.elotech.tributos.service.integracaoprotestocra.IntegracaoProtestoCraService;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import javax.xml.bind.JAXBException;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/protesto"})
public class ProtestoResource {
    private final ProtestoService protestoService;
    private final DocumentoProtestoService documentoProtestoService;
    private final GerarProtestoRemessaJobStarter gerarProtestoRemessaJobStarter;
    private final IntegracaoProtestoCraService integracaoProtestoCraService;

    @GetMapping(value={"/lotes-protesto"})
    public ResponseEntity<Page<LoteBatchInstanceDTO>> getTarefas(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.getLoteProtestos(Optional.of(search), pageable));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ProtestoDTO>> findAllProtestos(@RequestParam Optional<String> search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.getProtestos(search, pageable));
    }

    @GetMapping(value={"/lote-protesto/{idLote}"})
    public ResponseEntity<LoteBatchInstanceDTO> findLoteProtestosByIdJob(@PathVariable Long idLote) {
        return ResponseEntity.ok((Object)this.protestoService.findLoteProtestosByIdJob(idLote));
    }

    @GetMapping(value={"/protestos-lote/{idLote}"})
    public ResponseEntity<Page<ProtestoDTO>> findProtestosByLote(@PathVariable Long idLote, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.findProtestosByLote(idLote, pageable));
    }

    @PostMapping(value={"/gerar-documentos-agrupados"})
    public ResponseEntity<Void> agruparDocumentosProtesto(@RequestBody List<ProtestoDTO> protestos) throws IOException {
        this.documentoProtestoService.agruparDocumentoEnvioCRA(protestos);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/print-protesto/{idProtesto}"})
    public ResponseEntity<String> printDocumentoAgrupadoProtesto(@PathVariable Long idProtesto) {
        return ResponseEntity.ok((Object)this.protestoService.getUrlArquivoAgrupadoProtesto(idProtesto));
    }

    @PostMapping(value={"/gerar-termo-protesto"})
    public ResponseEntity<UUID> gerarTermoProtesto(@Valid @RequestBody FileProtestoParams params) throws IOException {
        return ResponseEntity.ok((Object)this.documentoProtestoService.gerarTermoProtesto(params.getIdProtesto(), params.getDataReferencia()));
    }

    @GetMapping(value={"/print-protesto-by-id-termo-s3/{idTermoProtestoS3}"})
    public ResponseEntity<String> printDocumentoAgrupadoProtesto(@PathVariable UUID idTermoProtestoS3) {
        return ResponseEntity.ok((Object)this.documentoProtestoService.getUrlAssinada(idTermoProtestoS3));
    }

    @PostMapping(value={"/gerar-remessa"})
    public ResponseEntity<Void> gerarRemessa(@RequestBody GerarProtestoRemessaDTO gerarProtestoRemessaDTO) {
        this.gerarProtestoRemessaJobStarter.startJob(gerarProtestoRemessaDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idProtesto}/status-cra"})
    public ResponseEntity<CraRetornoConsultaTituloDTO> consultarProtestoCra(@PathVariable Long idProtesto) throws MalformedURLException, JAXBException, RemoteException {
        Protesto protesto = (Protesto)this.protestoService.findById((Serializable)idProtesto).orElseThrow();
        CraRetornoConsultaTituloDTO craRetornoConsultaTituloDTO = this.integracaoProtestoCraService.consultarRemessa(protesto);
        return ResponseEntity.ok((Object)craRetornoConsultaTituloDTO);
    }

    @PatchMapping(value={"/cancelar/{idProtesto}"})
    public ResponseEntity<Void> cancelarProtesto(@PathVariable(value="idProtesto") Long idProtesto) {
        this.protestoService.cancelarProtesto(idProtesto);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/verifica-debitos-baixados/{idProtesto}"})
    public ResponseEntity<Void> verificaDebitosBaixados(@PathVariable(value="idProtesto") Long idProtesto) {
        this.protestoService.verificaDebitosBaixados(idProtesto);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/imprimir-documento-anuencia"})
    public ResponseEntity<ImpressaoDTO> imprimirDocumentoAnuencia(@RequestBody @Valid GeracaoDocumentoSimplificadoRequest request) {
        return ResponseEntity.ok((Object)this.protestoService.imprimeDocumentoAnuencia(request));
    }

    @Generated
    public ProtestoResource(ProtestoService protestoService, DocumentoProtestoService documentoProtestoService, GerarProtestoRemessaJobStarter gerarProtestoRemessaJobStarter, IntegracaoProtestoCraService integracaoProtestoCraService) {
        this.protestoService = protestoService;
        this.documentoProtestoService = documentoProtestoService;
        this.gerarProtestoRemessaJobStarter = gerarProtestoRemessaJobStarter;
        this.integracaoProtestoCraService = integracaoProtestoCraService;
    }
}

