/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.cda;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.ValidacaoDadosContribuintesDTO;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.batch.cda.GeracaoProtestoLoteCdaJobStarter;
import br.com.elotech.tributos.service.batch.cda.SimulacaoLoteCdaJobStarter;
import br.com.elotech.tributos.service.documento.cda.GeraLoteCertidaoDividaAtivaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemPessoaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.Callable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes-cda"})
public class LoteCdaResource
extends CrudResource<LoteCda, Long> {
    private final LoteCdaService loteCdaService;
    private final GeraLoteCertidaoDividaAtivaService geraLoteCertidaoDividaAtivaService;
    private final LoteCdaItemPessoaService loteCdaItemPessoaService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final SimulacaoLoteCdaJobStarter simulacaoLoteCdaJobStarter;
    private final BatchService batchService;
    private final ObjectMapper objectMapper;
    private final GeracaoProtestoLoteCdaJobStarter geracaoProtestoLoteCdaJobStarter;
    private final ParametroGeralService parametroGeralService;

    @PostMapping(value={"/gerar-simulacao"})
    public ResponseEntity<Void> gerarSimulacao(@RequestBody @Valid GeracaoLoteCdaDTO geracaoDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        geracaoDTO.setPermiteDebitoMaisDeUmaCda(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_MAIS_DE_UMA_CDA_POR_DEBITO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        Long idLote = this.loteCdaService.gerarLoteSimulacao(geracaoDTO.filterWithValues()).getId();
        this.simulacaoLoteCdaJobStarter.startJob(idLote, geracaoDTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/refazer-simulacao/{jobExecutionId}"})
    public ResponseEntity<Void> refazerSimulacao(@PathVariable Long jobExecutionId) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        JobParameters jobParameters = this.batchService.getJobParametersById(jobExecutionId);
        GeracaoLoteCdaDTO geracaoDTO = (GeracaoLoteCdaDTO)this.objectMapper.readValue(jobParameters.getString("geracaoLoteCdaDto"), GeracaoLoteCdaDTO.class);
        geracaoDTO.setPermiteDebitoMaisDeUmaCda(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_MAIS_DE_UMA_CDA_POR_DEBITO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        Long idLote = this.loteCdaService.gerarLoteSimulacao(geracaoDTO.filterWithValues()).getId();
        this.simulacaoLoteCdaJobStarter.startJob(idLote, geracaoDTO);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/{id}/gerar-certidoes"})
    public ResponseEntity<Void> gerarCertidoes(@PathVariable Long id) {
        this.geraLoteCertidaoDividaAtivaService.gerarCertidoesAsync(id, SecurityUtils.getUserSecurityDTO());
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<LoteCdaResumoDTO> getResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.loteCdaService.getResumo(id));
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<LoteCdaItem>> searchItens(@PathVariable Long id, @RequestParam(required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.loteCdaService.searchItens(id, search, pageable));
    }

    @PostMapping(value={"/{idLote}/revalidar-dados-contribuintes"})
    public ResponseEntity<ValidacaoDadosContribuintesDTO> revalidarDadosContribuintes(@PathVariable Long idLote) {
        return ResponseEntity.ok((Object)this.loteCdaItemPessoaService.revalidarDadosContribuintes(idLote));
    }

    @GetMapping(value={"/{id}/imprimirCdaLote"})
    public Callable<Void> printLoteCda(@PathVariable Long id, @RequestParam(required=false, defaultValue="") String search, @RequestParam(value="totalCdas") Integer totalCdas, Sort sort) {
        return () -> {
            Boolean tarefaEmExcucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.IMPRESSAO_CDA_LOTE, "ID_LOTE_CDA", id.toString());
            if (Boolean.TRUE.equals(tarefaEmExcucao)) {
                throw new EloValidationException("J\u00e1 existe uma tarefa com este par\u00e2metro informado em execu\u00e7\u00e3o.");
            }
            this.loteCdaService.printCDALoteAgrupado(id, search, sort, totalCdas);
            return null;
        };
    }

    @GetMapping(value={"/{idArquivo}/download"})
    public ResponseEntity<String> downloadLoteCDAAgrupado(@PathVariable String idArquivo) {
        return ResponseEntity.ok((Object)this.loteCdaService.getUrlArquivoLoteCDA(idArquivo));
    }

    @PostMapping(value={"/protestar-lote/{idLote}"})
    public ResponseEntity<String> protestarLote(@PathVariable Long idLote) {
        this.geracaoProtestoLoteCdaJobStarter.startJob(idLote);
        return ResponseEntity.ok().build();
    }

    @Generated
    public LoteCdaResource(LoteCdaService loteCdaService, GeraLoteCertidaoDividaAtivaService geraLoteCertidaoDividaAtivaService, LoteCdaItemPessoaService loteCdaItemPessoaService, TarefaAssincronaService tarefaAssincronaService, SimulacaoLoteCdaJobStarter simulacaoLoteCdaJobStarter, BatchService batchService, ObjectMapper objectMapper, GeracaoProtestoLoteCdaJobStarter geracaoProtestoLoteCdaJobStarter, ParametroGeralService parametroGeralService) {
        this.loteCdaService = loteCdaService;
        this.geraLoteCertidaoDividaAtivaService = geraLoteCertidaoDividaAtivaService;
        this.loteCdaItemPessoaService = loteCdaItemPessoaService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.simulacaoLoteCdaJobStarter = simulacaoLoteCdaJobStarter;
        this.batchService = batchService;
        this.objectMapper = objectMapper;
        this.geracaoProtestoLoteCdaJobStarter = geracaoProtestoLoteCdaJobStarter;
        this.parametroGeralService = parametroGeralService;
    }
}

