/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.autoinfracao.Penalidade;
import br.com.elotech.tributos.domain.autoinfracao.PenalidadeId;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoPenalidadeDTO;
import br.com.elotech.tributos.service.autoinfracao.PenalidadeService;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/penalidades"})
public class PenalidadeResource
extends CrudResource<Penalidade, PenalidadeId> {
    private final PenalidadeService penalidadeService;

    @GetMapping(value={"/pk/{entidade}/{exercicio}/{penalidade}"})
    public ResponseEntity<Penalidade> getByPk(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="penalidade") Long penalidade) {
        return this.findOne((Serializable)PenalidadeId.from((Long)entidade, (Long)exercicio, (Long)penalidade));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{penalidade}"})
    public ResponseEntity<Penalidade> updateByPk(@RequestBody @Valid Penalidade entity, Authentication authentication, @PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="penalidade") Long penalidade) {
        return this.update((EloEntity)entity, (Serializable)PenalidadeId.from((Long)entidade, (Long)exercicio, (Long)penalidade), authentication);
    }

    @DeleteMapping(value={"/{entidade}/{exercicio}/{penalidade}"})
    public ResponseEntity<Void> deleteByPk(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="penalidade") Long penalidade, Authentication authentication) {
        return this.remove((Serializable)PenalidadeId.from((Long)entidade, (Long)exercicio, (Long)penalidade), authentication);
    }

    @GetMapping(value={"/tipo-auto/{idTipoAutoInfracao}"})
    public ResponseEntity<List<AutoInfracaoPenalidadeDTO>> getVinculadosAoTipoAutoInfracao(@PathVariable Long idTipoAutoInfracao) {
        return ResponseEntity.ok((Object)this.penalidadeService.getPenalidadesVinculadasTipoInfracao(idTipoAutoInfracao));
    }

    @Generated
    public PenalidadeResource(PenalidadeService penalidadeService) {
        this.penalidadeService = penalidadeService;
    }
}

