/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoContencioso;
import br.com.elotech.tributos.dto.contencioso.TipoContenciosoResponseDTO;
import br.com.elotech.tributos.service.TipoContencioService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipo-contencioso"})
public class TipoContenciosoResource {
    private TipoContencioService tipoContencioService;

    public TipoContenciosoResource(TipoContencioService tipoContencioService) {
        this.tipoContencioService = tipoContencioService;
    }

    @GetMapping
    public ResponseEntity<Page<TipoContenciosoResponseDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page tipoContenciosoPage = this.tipoContencioService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)tipoContenciosoPage.map(TipoContenciosoResponseDTO::of));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoContenciosoResponseDTO> getTipoContencioso(@PathVariable Long id) {
        TipoContencioso tipoContencios = this.tipoContencioService.findTipoContenciosoById(id);
        return ResponseEntity.ok((Object)TipoContenciosoResponseDTO.of((TipoContencioso)tipoContencios));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TipoContenciosoResponseDTO> update(@PathVariable Long id, @RequestBody @Valid TipoContenciosoResponseDTO tipoContenciosoResponseDTO) {
        TipoContencioso tipoContencios = this.tipoContencioService.update(id, tipoContenciosoResponseDTO);
        return ResponseEntity.ok((Object)TipoContenciosoResponseDTO.of((TipoContencioso)tipoContencios));
    }

    @PostMapping
    public ResponseEntity<TipoContenciosoResponseDTO> create(@RequestBody @Valid TipoContenciosoResponseDTO tipoContenciosoResponseDTO) {
        TipoContencioso tipoContencios = this.tipoContencioService.create(tipoContenciosoResponseDTO);
        return ResponseEntity.ok((Object)TipoContenciosoResponseDTO.of((TipoContencioso)tipoContencios));
    }
}

