/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.RegimeFiscalDTO;
import br.com.elotech.tributos.service.RegimeFiscalService;
import java.net.URI;
import javax.transaction.Transactional;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/regime-fiscal"})
public class RegimeFiscalResource
extends ReadOnlyResource<RegimeFiscal, Long> {
    private final RegimeFiscalService regimeFiscalService;

    public RegimeFiscalResource(RegimeFiscalService regimeFiscalService) {
        this.regimeFiscalService = regimeFiscalService;
    }

    @Transactional
    @PostMapping
    public ResponseEntity<RegimeFiscalDTO> save(@RequestBody @Valid RegimeFiscalDTO regimeFiscalDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.regimeFiscalService.save(regimeFiscalDTO));
    }

    @Transactional
    @PutMapping(value={"/{id}"})
    public ResponseEntity<RegimeFiscalDTO> edit(@PathVariable Long id, @RequestBody @Valid RegimeFiscalDTO regimeFiscalDTO) {
        return ResponseEntity.ok((Object)this.regimeFiscalService.edit(id, regimeFiscalDTO));
    }

    @Transactional
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") Long id) {
        this.regimeFiscalService.delete(id);
        return ResponseEntity.noContent().build();
    }
}

