/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoProprietarioDTO;
import br.com.elotech.tributos.params.RastreamentoCadastralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceFactory;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/rastreamento"})
public class RastreamentoResource {
    private final RastreamentoServiceFactory rastreamentoServiceFactory;
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;

    public RastreamentoResource(RastreamentoServiceFactory rastreamentoServiceFactory, CadastroGeralService cadastroGeralService, PessoaService pessoaService) {
        this.rastreamentoServiceFactory = rastreamentoServiceFactory;
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
    }

    @GetMapping(value={"/cadastro/{idCadastro}"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porCadastro(@PathVariable Long idCadastro) {
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoServiceFactory.getService().porCadastro(idCadastro)));
    }

    @GetMapping(value={"/contribuinte/{idContribuinte}"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porContribuinte(@PathVariable Long idContribuinte) {
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoServiceFactory.getService().porContribuinte(idContribuinte)));
    }

    @GetMapping(value={"/contribuinte"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porContribuinteUtilizandoCadastro(@RequestParam(value="idCadastro") Long idCadastro) {
        Pessoa responsavel = this.cadastroGeralService.getResponsavel(idCadastro);
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoServiceFactory.getService().porContribuinte(responsavel.getId())));
    }

    @GetMapping(value={"/contribuinte/cpfCnpj"}, params={"cpfCnpj", "utilizaCorresponsavel"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porContribuinteUtilizandoCpfCnpj(RastreamentoCadastralParams params) {
        Pessoa pessoa = Optional.ofNullable(this.pessoaService.findByCnpjCpf(params.getCpfCnpj())).orElseThrow(() -> new PessoaNotFoundException(params.getCpfCnpj()));
        RastreamentoConsultaDTO rastreamentoConsultaDTO = RastreamentoConsultaDTO.builder().idContribuinte(pessoa.getId()).utilizaCorresponsavel(params.getUtilizaCorresponsavel()).build();
        return ResponseEntity.ok((Object)this.ordenarCadastrosByProprietarios(this.rastreamentoServiceFactory.getService().porContribuinte(rastreamentoConsultaDTO)));
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral", "utilizaCorresponsavel"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> getByTipoCadastroAndCadastroGeral(RastreamentoCadastralParams params) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral()).orElseThrow(() -> new CadastroNaoEncontradoException(params.getTipoCadastro(), params.getCadastroGeral()));
        RastreamentoConsultaDTO rastreamentoConsultaDTO = RastreamentoConsultaDTO.builder().idCadastro(cadastroGeral.getId()).utilizaCorresponsavel(params.getUtilizaCorresponsavel()).build();
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoServiceFactory.getService().porCadastro(rastreamentoConsultaDTO)));
    }

    @PostMapping(value={"/imprimir-rastreamento-detalhado"})
    public void imprimirRastreamentoDetalhado(@RequestBody List<RastreamentoCadastroDTO> param, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.rastreamentoServiceFactory.getService().imprimirRastreamento(param, Boolean.TRUE);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar a impress\u00e3o do Rastreamento.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"rastreamentcadastral.pdf");
    }

    @PostMapping(value={"/imprimir-rastreamento-simples"})
    public void imprimirRastreamentoSimples(@RequestBody List<RastreamentoCadastroDTO> param, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.rastreamentoServiceFactory.getService().imprimirRastreamento(param, Boolean.FALSE);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar a impress\u00e3o do Rastreamento.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"rastreamentcadastral.pdf");
    }

    private List<RastreamentoCadastroDTO> ordenarCadastros(Set<RastreamentoCadastroDTO> cadastros) {
        return cadastros.stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toList());
    }

    private List<RastreamentoCadastroDTO> ordenarCadastrosByProprietarios(Set<RastreamentoCadastroDTO> cadastros) {
        return cadastros.stream().sorted(Comparator.comparing(item -> Optional.ofNullable(item.getProprietarios()).flatMap(proprietarios -> proprietarios.stream().findFirst()).map(RastreamentoProprietarioDTO::getVinculoDescricao).orElse(""))).collect(Collectors.toList());
    }
}

