/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.ClassificacaoReceitaResponseDTO;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.ResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.TotalResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.params.MovimentacaoTributoParams;
import br.com.elotech.tributos.repository.ClassificacaoReceitaRepository;
import br.com.elotech.tributos.service.MovimentacaoTributoService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/movimentacao-tributo"})
public class MovimentacaoTributoResource {
    private final MovimentacaoTributoService movimentacaoTributoService;
    private final ClassificacaoReceitaRepository classificacaoReceitaRepository;

    @GetMapping
    public ResponseEntity<Page<MovimentacaoTributoDTO>> findMovimentacoes(@Valid MovimentacaoTributoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.findMovimentacoes(params, pageable));
    }

    @GetMapping(value={"/classificacoes"})
    public ResponseEntity<List<ClassificacaoReceitaResponseDTO>> getClassificacoes() {
        return ResponseEntity.ok(this.classificacaoReceitaRepository.findAll().stream().map(receita -> new ClassificacaoReceitaResponseDTO(receita.getId(), receita.getDescricao())).collect(Collectors.toList()));
    }

    @GetMapping(value={"/resumo"})
    public ResponseEntity<Page<ResumoMovimentacaoTributoDTO>> getResumo(@Valid MovimentacaoTributoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.getResumos(params, pageable));
    }

    @GetMapping(value={"/total-resumo"})
    public ResponseEntity<TotalResumoMovimentacaoTributoDTO> getTotalResumo(@Valid MovimentacaoTributoParams params) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.getTotalResumo(params));
    }

    @Generated
    public MovimentacaoTributoResource(MovimentacaoTributoService movimentacaoTributoService, ClassificacaoReceitaRepository classificacaoReceitaRepository) {
        this.movimentacaoTributoService = movimentacaoTributoService;
        this.classificacaoReceitaRepository = classificacaoReceitaRepository;
    }
}

