/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.MovimentacaoDiariaDTO;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/movimentacao-diaria"})
public class MovimentacaoDiariaResource {
    private final MovimentacaoDiariaService movimentacaoDiariaService;

    public MovimentacaoDiariaResource(MovimentacaoDiariaService movimentacaoDiariaService) {
        this.movimentacaoDiariaService = movimentacaoDiariaService;
    }

    @PutMapping(value={"/abrir"})
    public ResponseEntity<Void> abrirDatas(@RequestBody List<LocalDate> datasSelecionadas) {
        this.movimentacaoDiariaService.abrirDatas(datasSelecionadas);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/fechar"})
    public ResponseEntity<Void> fecharDatas(@RequestBody List<LocalDate> datasSelecionadas) {
        this.movimentacaoDiariaService.fecharDatas(datasSelecionadas);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/situacao/{entidade}/{mes}/{ano}"})
    public ResponseEntity<List<MovimentacaoDiariaDTO>> findSituacaoByMesAno(@PathVariable(value="entidade") Long entidade, @PathVariable(value="mes") Long mes, @PathVariable(value="ano") Long ano) {
        return ResponseEntity.ok((Object)this.movimentacaoDiariaService.findSituacaoByMesAno(entidade, mes, ano));
    }

    @GetMapping(path={"/situacao"}, params={"dataMovimento"})
    public ResponseEntity<MovimentacaoDiariaDTO> findSituacaoByData(@RequestParam(value="dataMovimento") String dataMovimento) {
        return ResponseEntity.ok((Object)this.movimentacaoDiariaService.findSituacaoByDataMovimento(dataMovimento));
    }
}

