/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.LogradouroTrecho;
import br.com.elotech.tributos.dto.LogradouroTrechoDTO;
import br.com.elotech.tributos.repository.LogradouroTrechoRepository;
import br.com.elotech.tributos.service.LogradouroTrechoService;
import java.io.Serializable;
import java.net.URI;
import javax.transaction.Transactional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/logradourotrechos"})
@Transactional
public class LogradouroTrechoResource {
    private final LogradouroTrechoRepository logradouroTrechoRepository;
    private final LogradouroTrechoService logradouroTrechoService;

    @GetMapping(params={"distrito", "setor", "logradourotrecho"})
    public ResponseEntity<LogradouroTrecho> findOne(@RequestParam(value="distrito") String distrito, @RequestParam(value="setor") String setor, @RequestParam(value="logradourotrecho") Long logradouroTrecho) {
        LogradouroTrecho logradouroTrechoEntity = this.logradouroTrechoRepository.findBySetorDistritoDistritoAndSetorSetorAndLogradouroTrecho(distrito, setor, logradouroTrecho);
        return ResponseEntity.ok((Object)logradouroTrechoEntity);
    }

    @GetMapping
    public ResponseEntity<Page<LogradouroTrechoDTO>> findAllDto(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.logradouroTrechoService.findByRsql(search, pageable).map(LogradouroTrechoDTO::from));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTrechoDTO> findOneDto(@PathVariable(value="id") Long id) {
        return this.logradouroTrechoService.findById((Serializable)id).map(LogradouroTrechoDTO::from).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<LogradouroTrechoDTO> save(@RequestBody @Valid LogradouroTrechoDTO logradouroTrecho) {
        LogradouroTrecho trecho = this.logradouroTrechoService.saveDto(logradouroTrecho);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequest();
        URI uriLocation = builder.path("/{id}").buildAndExpand(new Object[]{trecho.getId()}).toUri();
        return ResponseEntity.created((URI)uriLocation).body((Object)LogradouroTrechoDTO.from((LogradouroTrecho)trecho));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTrechoDTO> update(@PathVariable Long id, @RequestBody @Valid LogradouroTrechoDTO logradouroTrecho) {
        return ResponseEntity.ok((Object)LogradouroTrechoDTO.from((LogradouroTrecho)this.logradouroTrechoService.updateDto(id, logradouroTrecho)));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTrechoDTO> exclusaoLogica(@PathVariable Long id) {
        LogradouroTrecho logradouroTrecho = this.logradouroTrechoService.marcarComoExclusaoLogica(id);
        return ResponseEntity.ok((Object)LogradouroTrechoDTO.from((LogradouroTrecho)logradouroTrecho));
    }

    @PutMapping(value={"/{id}/restore"})
    public ResponseEntity<LogradouroTrechoDTO> reabilitarExclusaoLogica(@PathVariable Long id) {
        LogradouroTrecho logradouroTrecho = this.logradouroTrechoService.desfazerExclusaoLogica(id);
        return ResponseEntity.ok((Object)LogradouroTrechoDTO.from((LogradouroTrecho)logradouroTrecho));
    }

    @Generated
    public LogradouroTrechoResource(LogradouroTrechoRepository logradouroTrechoRepository, LogradouroTrechoService logradouroTrechoService) {
        this.logradouroTrechoRepository = logradouroTrechoRepository;
        this.logradouroTrechoService = logradouroTrechoService;
    }
}

