/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.LogradouroTestadaExercicio;
import br.com.elotech.tributos.dto.LogradouroBatchUpdateDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LogradouroTestadaExercicioResumoDTO;
import br.com.elotech.tributos.service.LogradouroTestadaExercicioService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logradouros-testada-exercicio"})
public class LogradouroTestadaExercicioResource
extends CrudResource<LogradouroTestadaExercicio, Long> {
    private final LogradouroTestadaExercicioService logradouroTestadaExercicioService;

    public LogradouroTestadaExercicioResource(LogradouroTestadaExercicioService logradouroTestadaExercicioService) {
        this.logradouroTestadaExercicioService = logradouroTestadaExercicioService;
    }

    @GetMapping(path={"/resumo-dto"})
    public ResponseEntity<Page<LogradouroTestadaExercicioResumoDTO>> findResumoDTO(@RequestParam String search, Pageable pageable) {
        Page result = this.logradouroTestadaExercicioService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)result.map(LogradouroTestadaExercicioResumoDTO::from));
    }

    @PutMapping(path={"/batch-update"})
    public ResponseEntity<Void> batchUpdate(@RequestBody LogradouroBatchUpdateDTO batchUpdateDTO) {
        this.logradouroTestadaExercicioService.validateBatchUpdateSearch(batchUpdateDTO.getSearch());
        Page logradouroTestadaExercicios = this.logradouroTestadaExercicioService.findByRsql(batchUpdateDTO.getSearch(), Pageable.unpaged());
        this.logradouroTestadaExercicioService.batchUpdate(batchUpdateDTO, logradouroTestadaExercicios);
        return ResponseEntity.ok().build();
    }
}

