/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.dto.ValoresAvaliacaoImobiliarioDTO;
import br.com.elotech.tributos.params.ImobiliarioSegmentoParams;
import br.com.elotech.tributos.projection.ImobiliarioAvaliacaoProjection;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ImobiliarioAvaliacaoService;
import br.com.elotech.tributos.service.ImobiliarioAvaliacaoValoresService;
import java.io.Serializable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/imobiliario-avaliacao"})
public class ImobiliarioAvaliacaoResource {
    private final ImobiliarioAvaliacaoService imobiliarioAvaliacaoService;
    private final ImobiliarioAvaliacaoValoresService imobiliarioAvaliacaoValoresService;
    private final CadastroGeralService cadastroGeralService;

    public ImobiliarioAvaliacaoResource(ImobiliarioAvaliacaoService imobiliarioAvaliacaoService, ImobiliarioAvaliacaoValoresService imobiliarioAvaliacaoValoresService, CadastroGeralService cadastroGeralService) {
        this.imobiliarioAvaliacaoService = imobiliarioAvaliacaoService;
        this.imobiliarioAvaliacaoValoresService = imobiliarioAvaliacaoValoresService;
        this.cadastroGeralService = cadastroGeralService;
    }

    @GetMapping(params={"cadastroGeral"})
    public ResponseEntity<ImobiliarioAvaliacaoProjection> imobiliarioAvaliacao(Long cadastroGeral) {
        return ResponseEntity.ok().body((Object)this.imobiliarioAvaliacaoService.imobiliarioAvaliacao(cadastroGeral));
    }

    @GetMapping(value={"/calcular-valores"}, params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<ValoresAvaliacaoImobiliarioDTO> calcularValores(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        return ResponseEntity.ok().body((Object)this.imobiliarioAvaliacaoValoresService.calcularValoresAvaliacao(tipoCadastro, cadastroGeral));
    }

    @PostMapping(value={"/calcular-valores-segmento"})
    public ResponseEntity<ValoresAvaliacaoImobiliarioDTO> calcularValoresSegmento(@RequestBody ImobiliarioSegmentoParams segmento) {
        return ResponseEntity.ok().body((Object)this.imobiliarioAvaliacaoValoresService.calcularValoresSegmento(segmento));
    }

    @GetMapping(value={"/calcular-valores-by-cadastro-geral-id/{id}"})
    public ResponseEntity<ValoresAvaliacaoImobiliarioDTO> calcularValoresByCadastroGeralId(@PathVariable(value="id") Long id) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)id);
        return ResponseEntity.ok().body((Object)this.imobiliarioAvaliacaoValoresService.calcularValoresAvaliacao(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()));
    }
}

