/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.dto.ImobiliariaDTO;
import br.com.elotech.tributos.service.ImobiliariaService;
import javax.transaction.Transactional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/imobiliarias"})
public class ImobiliariaResource
extends ReadOnlyResource<Imobiliaria, Long> {
    private final ImobiliariaService imobiliariaService;

    public ImobiliariaResource(ImobiliariaService imobiliariaService) {
        this.imobiliariaService = imobiliariaService;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ImobiliariaDTO>> getImobiliarias(@RequestParam(required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.imobiliariaService.getImobiliarias(search, pageable));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<ImobiliariaDTO> getResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.imobiliariaService.getResumo(id));
    }

    @Transactional
    @PostMapping
    public ResponseEntity<ImobiliariaDTO> save(@RequestBody ImobiliariaDTO imobiliariaDTO) {
        return ResponseEntity.ok((Object)this.imobiliariaService.save(imobiliariaDTO));
    }

    @Transactional
    @PutMapping(value={"/{id}"})
    public ResponseEntity<ImobiliariaDTO> edit(@PathVariable(value="id") Long id, @RequestBody ImobiliariaDTO imobiliariaDTO) {
        return ResponseEntity.ok((Object)this.imobiliariaService.edit(id, imobiliariaDTO));
    }

    @Transactional
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") Long id) {
        this.imobiliariaService.delete(id);
        return ResponseEntity.ok().build();
    }
}

