/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.parcelamento.EstornoParcelamento;
import br.com.elotech.tributos.dto.parcelamento.AiseEstornoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoEstornoParcelamentoDTO;
import br.com.elotech.tributos.service.ws.AiseEstornoParcelamentoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estornos-parcelamento"})
public class EstornoParcelamentoResource
extends ReadOnlyResource<EstornoParcelamento, Long> {
    private final AiseEstornoParcelamentoService aiseEstornoParcelamentoService;

    public EstornoParcelamentoResource(AiseEstornoParcelamentoService aiseEstornoParcelamentoService) {
        this.aiseEstornoParcelamentoService = aiseEstornoParcelamentoService;
    }

    @PostMapping(value={"/simular"})
    public ResponseEntity<SimulacaoEstornoParcelamentoDTO> simularEstornoParcelamento(@RequestBody AiseEstornoParcelamentoDTO request) {
        return ResponseEntity.ok((Object)this.aiseEstornoParcelamentoService.simularEstornoParcelamento(request));
    }

    @PostMapping
    public ResponseEntity<AiseEstornoParcelamentoDTO> estornarParcelamento(@RequestBody AiseEstornoParcelamentoDTO request) {
        return ResponseEntity.ok((Object)this.aiseEstornoParcelamentoService.estornarParcelamento(request));
    }

    @PostMapping(value={"/{idEstornoParcelamento}/desfazer"})
    public ResponseEntity<AiseEstornoParcelamentoDTO> desfazerEstornoParcelamento(@PathVariable Long idEstornoParcelamento) {
        this.aiseEstornoParcelamentoService.desfazerEstornoParcelamento(idEstornoParcelamento);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/estorno-parcelamento-em-lote"})
    public ResponseEntity<List<AiseEstornoParcelamentoDTO>> estornoParcelamentoEmLote(@RequestBody List<AiseEstornoParcelamentoDTO> requests) {
        return ResponseEntity.ok((Object)this.aiseEstornoParcelamentoService.estornarParcelamentoEmLote(requests));
    }
}

