/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoArquivoS3;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.ContenciosoResponseDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosResponseDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoGerarBoletoDTO;
import br.com.elotech.tributos.dto.contencioso.FiltroDebitosContenciosoDTO;
import br.com.elotech.tributos.service.ContenciosoRecalculoService;
import br.com.elotech.tributos.service.ContenciosoService;
import br.com.elotech.tributos.service.DebitoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contenciosos"})
public class ContenciosoResource
extends ReadOnlyResource<Contencioso, Long> {
    private final ContenciosoService contenciosoService;
    private final ContenciosoRecalculoService contenciosoRecalculoService;
    private final DebitoService debitoService;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ContenciosoResponseDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page contencioso = this.contenciosoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)contencioso.map(ContenciosoResponseDTO::of));
    }

    @GetMapping(value={"/{id}/dto"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> findDtoById(@PathVariable Long id) {
        Contencioso contencioso = (Contencioso)this.contenciosoService.findOne((Serializable)id);
        if (Objects.isNull(contencioso)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar contencioso com id %d", id));
        }
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PostMapping
    public ResponseEntity<ContenciosoDebitosResponseDTO> create(@RequestBody @Valid ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        Contencioso contencioso = this.contenciosoService.create(contenciosoDebitosResponseDTO);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PostMapping(value={"/{id}/exarar"})
    public ResponseEntity<ContenciosoDebitosExararDTO> exarar(@RequestBody @Valid ContenciosoDebitosExararDTO contenciosoDebitosResponseDTO, @PathVariable Long id) {
        Contencioso contencioso = this.contenciosoService.exarar(contenciosoDebitosResponseDTO, id);
        return ResponseEntity.ok((Object)ContenciosoDebitosExararDTO.of((Contencioso)contencioso));
    }

    @PostMapping(value={"/{id}/exararManterDebito"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> exararManterDebito(@RequestBody @Valid ContenciosoDebitosExararDTO contenciosoDebitosResponseDTO, @PathVariable Long id) {
        Contencioso contencioso = this.contenciosoService.exararManterDebitos(contenciosoDebitosResponseDTO, id);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ContenciosoDebitosResponseDTO> put(@RequestBody @Valid ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        Contencioso contencioso = this.contenciosoService.create(contenciosoDebitosResponseDTO);
        return ResponseEntity.ok((Object)ContenciosoDebitosResponseDTO.of((Contencioso)contencioso));
    }

    @GetMapping(value={"/filtrar-debitos"})
    public ResponseEntity<Page<Debito>> search(FiltroDebitosContenciosoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.debitoService.buscarDebitos(filtro, pageable));
    }

    @PostMapping(value={"/{id}/recalcular"})
    public ResponseEntity<Void> recalcularContencioso(@PathVariable Long id, @RequestBody @Valid ContenciosoRecalculoDTO contenciosoRecalculoDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        this.contenciosoRecalculoService.recalcularContencioso(id, contenciosoRecalculoDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/gerar-boletos"})
    public ResponseEntity<Long> gerarBoletos(@PathVariable Long id, @RequestBody @Valid ContenciosoRecalculoGerarBoletoDTO contenciosoRecalculoGerarBoletoDTO) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        return ResponseEntity.ok((Object)this.contenciosoRecalculoService.gerarBoletosBatch(id, contenciosoRecalculoGerarBoletoDTO).getJobInstance().getInstanceId());
    }

    @PostMapping(value={"/{id}/gerar-cadastro-memoria"})
    public ResponseEntity<Void> generateCadastroMemoriaByIdContencioso(@PathVariable Long id) {
        this.contenciosoService.generateCadastroMemoriaByIdContencioso(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/download-boleto-carne/{idJobExecution}"})
    public ResponseEntity<Void> downloadBoletoCarne(@PathVariable Long idJobExecution, HttpServletResponse response) throws IOException {
        ContenciosoArquivoS3 contenciosoArquivoS3 = this.contenciosoRecalculoService.findByBatchJobExecutionId(idJobExecution);
        byte[] arquivo = this.contenciosoRecalculoService.download(contenciosoArquivoS3.getIdArquivoS3());
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)contenciosoArquivoS3.getNomeArquivo());
        return ResponseEntity.ok().build();
    }

    @Generated
    public ContenciosoResource(ContenciosoService contenciosoService, ContenciosoRecalculoService contenciosoRecalculoService, DebitoService debitoService) {
        this.contenciosoService = contenciosoService;
        this.contenciosoRecalculoService = contenciosoRecalculoService;
        this.debitoService = debitoService;
    }
}

