/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.AtualizaSituacaoCarneDTO;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.CarneResumoDTO;
import br.com.elotech.tributos.dto.CarneRowDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.FiltroConsultaCarneDTO;
import br.com.elotech.tributos.dto.GeraCarnePorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.enums.MotivoDevolucao;
import br.com.elotech.tributos.enums.SituacaoCarne;
import br.com.elotech.tributos.service.AiseCarneService;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneAiseDTO;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carne"})
public class CarneResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CarneResource.class);
    private final AiseCarneService aiseCarneService;
    private final AisePdfService aisePdfService;
    private final CarneService carneService;
    private final DebitoCarneService debitoCarneService;
    private final FormaPagamentoService formaPagamentoService;

    public CarneResource(AiseCarneService aiseCarneService, AisePdfService aisePdfService, CarneService carneService, DebitoCarneService debitoCarneService, FormaPagamentoService formaPagamentoService) {
        this.aiseCarneService = aiseCarneService;
        this.aisePdfService = aisePdfService;
        this.carneService = carneService;
        this.debitoCarneService = debitoCarneService;
        this.formaPagamentoService = formaPagamentoService;
    }

    @PostMapping
    public ImpressaoDTO geraCarneAise(@RequestBody DebitoCarneAiseDTO params) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.aiseCarneService.geraCarne(params).getNumeroCarne()));
    }

    @PostMapping(value={"/gerar"})
    public ImpressaoDTO geraCarne(@RequestBody DebitoCarneDTO debitoCarne) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.carneService.geraCarne(debitoCarne).getNumeroCarne()));
    }

    @PostMapping(path={"/gera-carne-forma-pagamento"})
    public ImpressaoDTO geraBloquetoPorFormaPagamento(@RequestBody GeraCarnePorFormaPagamentoDTO params) {
        log.debug("Iniciando gera\u00e7\u00e3o de carn\u00ea do debito {} com forma de pagamento {}", (Object)params.getIdDebito(), (Object)params.getFormaPagamento());
        CarneDTO carneDTO = this.carneService.findByDebito(params.getIdDebito(), params.getFormaPagamento()).map(carne -> {
            log.debug("Encontrado carne {}/{} associado ao d\u00e9bito {}", new Object[]{carne.getNumeroCarne(), carne.getExercicio(), params.getIdDebito()});
            return carne;
        }).orElseGet(() -> {
            log.debug("Gerando carn\u00ea pois o d\u00e9bito {} n\u00e3o possui carn\u00ea associado com a forma de pagamento {}.", (Object)params.getIdDebito(), (Object)params.getFormaPagamento());
            CarneDTO carne = this.aiseCarneService.geraCarnePorFormaPagamento(params);
            log.debug("Carn\u00ea {}/{} gerado para o d\u00e9bito {}", new Object[]{carne.getNumeroCarne(), carne.getExercicio(), params.getIdDebito()});
            if (this.podeAssociarCarneGeradoNoDebito(params)) {
                log.debug("Associando o carn\u00ea {} com a forma de pagamento {} no d\u00e9bito {}", new Object[]{carne.getNumeroCarne(), params.getFormaPagamento(), params.getIdDebito()});
                this.debitoCarneService.associarCarneNoDebito(params.getIdDebito(), carne, params.getFormaPagamento());
                log.debug("Carn\u00ea associado");
            }
            return carne;
        });
        log.debug("Gerando url de impress\u00e3o para o carne {}/{}", (Object)carneDTO.getNumeroCarne(), (Object)carneDTO.getExercicio());
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarnePorFormaPagamento(carneDTO.getNumeroCarne(), params.getFormaPagamento()));
    }

    private boolean podeAssociarCarneGeradoNoDebito(GeraCarnePorFormaPagamentoDTO params) {
        return this.formaPagamentoService.findById((Serializable)params.getFormaPagamento()).map(formaPagamento -> !TipoFormaPagamento.COTA_UNICA.equals((Object)formaPagamento.getTipoFormaPagamento())).orElse(Boolean.FALSE);
    }

    @PostMapping(path={"/gera-carne-forma-pagamento/gerar"})
    public ImpressaoDTO geraCarnePorFormaPagamento(@RequestBody DebitoAgrupadoPorFormaPagamentoDTO params) {
        CarneDTO carneDTO = this.carneService.geraCarnePorFormaPagamento(params);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(carneDTO.getNumeroCarne()));
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<Page<CarneRowDTO>> consultaCarnes(@RequestBody @Valid FiltroConsultaCarneDTO dto, Pageable pageable) {
        return ResponseEntity.ok((Object)this.carneService.consultaCarne(dto, pageable));
    }

    @PatchMapping
    public ResponseEntity<Void> atualizaSituacaoCarne(@RequestBody @Valid AtualizaSituacaoCarneDTO dto) {
        if (dto.getSituacaoCarne().equals((Object)SituacaoCarne.DEVOLVIDO) && Objects.isNull(dto.getMotivoDevolucao())) {
            throw new EloValidationException("O motivo da devolu\u00e7\u00e3o \u00e9 obrigat\u00f3rio.");
        }
        if (dto.getSituacaoCarne().equals((Object)SituacaoCarne.DEVOLVIDO) && dto.getMotivoDevolucao().equals((Object)MotivoDevolucao.OUTROS) && StringUtils.isBlank((CharSequence)dto.getObservacaoDevolucao())) {
            throw new EloValidationException(String.format("A observa\u00e7\u00e3o da devolu\u00e7\u00e3o com motivo %s \u00e9 obrigat\u00f3rio.", dto.getMotivoDevolucao().getDescricao()));
        }
        this.carneService.atualizaSituacaoCarne(dto);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/resumo"})
    public ResponseEntity<CarneResumoDTO> getCarne(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, @RequestParam(value="carne") Long carne) {
        return ResponseEntity.ok((Object)this.carneService.getResumoCarne(new CarneId(entidade, exercicio, carne)));
    }
}

