/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.service.CadastroGeralIsencaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.data.domain.Sort;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-geral-isencao"})
public class CadastroGeralIsencaoResource {
    private final CadastroGeralIsencaoService cadastroGeralIsencaoService;
    private final AuditService auditService;

    public CadastroGeralIsencaoResource(CadastroGeralIsencaoService cadastroGeralIsencaoService, AuditService auditService) {
        this.cadastroGeralIsencaoService = cadastroGeralIsencaoService;
        this.auditService = auditService;
    }

    @GetMapping(path={"/por-cadastro/{id}"})
    public ResponseEntity<List<CadastroGeralIsencao>> findIsencoes(@PathVariable Long id, Sort sort) {
        return ResponseEntity.ok((Object)this.cadastroGeralIsencaoService.findByCadastroGeralId(id, sort));
    }

    @GetMapping(path={"/por-cadastro/{id}/por-data"})
    public ResponseEntity<List<CadastroGeralIsencao>> findIsencoes(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroGeral cadastro = (CadastroGeral)this.auditService.getRecordAtDate(CadastroGeral.class, (Serializable)id, date);
        if (Objects.isNull(cadastro)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        List isencoes = cadastro.getCadastroGeralIsencoes();
        isencoes.sort(Comparator.comparingLong(CadastroGeralIsencao::getId).reversed());
        return ResponseEntity.ok((Object)isencoes);
    }

    @PostMapping
    public ResponseEntity<CadastroGeralIsencao> save(@RequestBody @Valid CadastroGeralIsencao isencao) {
        return ResponseEntity.ok((Object)this.cadastroGeralIsencaoService.create(isencao));
    }

    @PutMapping(path={"/{idIsencao}"})
    public ResponseEntity<CadastroGeralIsencao> update(@RequestBody @Valid CadastroGeralIsencao isencao, @PathVariable Long idIsencao) {
        return ResponseEntity.ok((Object)this.cadastroGeralIsencaoService.update(idIsencao, isencao));
    }

    @DeleteMapping(path={"/{idIsencao}"})
    public ResponseEntity<Void> delete(@PathVariable Long idIsencao) {
        this.cadastroGeralIsencaoService.delete(idIsencao);
        return ResponseEntity.ok().build();
    }
}

