/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.BatchInstanceDTO;
import br.com.elotech.tributos.dto.HistoricoBatchDTO;
import br.com.elotech.tributos.service.BatchService;
import java.util.List;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/batch"})
public class BatchResource {
    private final BatchService batchService;

    @PostMapping(value={"/retry/{jobExecutionId}"})
    public ResponseEntity<Void> retryJob(@PathVariable Long jobExecutionId) throws JobParametersInvalidException, JobRestartException, NoSuchJobException {
        this.batchService.retryJob(jobExecutionId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/stop/{jobExecutionId}"})
    public ResponseEntity<Void> stopJob(@PathVariable Long jobExecutionId) {
        this.batchService.stopJob(jobExecutionId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/invalidate/{jobExecutionId}"})
    public ResponseEntity<Void> invalidarJob(@PathVariable Long jobExecutionId) {
        if (Boolean.TRUE.equals(this.batchService.invalidate(jobExecutionId))) {
            return ResponseEntity.noContent().build();
        }
        throw new EloValidationException("Nenhum registro alterado");
    }

    @GetMapping(value={"/tarefas"})
    public ResponseEntity<Page<BatchInstanceDTO>> getTarefas(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.batchService.getTarefas(search, pageable));
    }

    @GetMapping(value={"/historico/{instanceId}"})
    public ResponseEntity<List<HistoricoBatchDTO>> getExecutionFromInstanceId(@PathVariable Long instanceId) {
        return ResponseEntity.ok((Object)this.batchService.findHistoricoExecutionByInstanceId(instanceId));
    }

    @GetMapping(value={"/instance/{jobExecutionId}"})
    public ResponseEntity<Long> getJobInstanceId(@PathVariable Long jobExecutionId) {
        return ResponseEntity.ok((Object)this.batchService.getJobInstanceId(jobExecutionId));
    }

    @Generated
    public BatchResource(BatchService batchService) {
        this.batchService = batchService;
    }
}

