/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.dto.AdvancedSearchParamsDTO;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroDebitoPorContribuinteDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.dto.SelectedFacetDTO;
import br.com.elotech.tributos.dto.TotalExtratoDebitoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoHistoricoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoInformacaoDashDebitoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoPagamentoDashDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoPeticaoDashDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtendimentoService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/atendimentos"})
public class AtendimentoResource {
    private final AtendimentoService atendimentoService;
    private final DebitoEmAbertoService debitoEmAbertoService;

    @GetMapping(value={"/debitos-aberto"})
    public ResponseEntity<List<DebitoEmAbertoDTO>> getDebitosEmAberto() {
        return this.atendimentoService.loadAtendimentoUser(SecurityUtils.getPreferredUsername()).map(atendimento -> this.atendimentoService.findDebitosEmAberto(atendimento.getCadastroGeral().getTipoCadastro(), atendimento.getCadastroGeral().getCadastroGeral())).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi encontrado atendimento em aberto para o usu\u00e1rio logado."));
    }

    @GetMapping(value={"/{tipoCadastro}/{cadastroGeral}/totais-extrato-debitos"})
    public ResponseEntity<Map<TipoExtratoDebitoEnum, TotalExtratoDebitoDTO>> getTotaisExtratoDebitos(@PathVariable Long tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.findTotaisExtratoDebitos(tipoCadastro, cadastroGeral));
    }

    @PostMapping(value={"/extrato-debitos"})
    public ResponseEntity<Page<ExtratoDebitoDTO>> getExtratoDebitos(@RequestBody FiltroExtratoDebitoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.atendimentoService.findExtratoDebitos(filtro, pageable));
    }

    @GetMapping(value={"/{tipoCadastro}/{cadastroGeral}/debitos/info"})
    public ResponseEntity<AtendimentoInformacaoDashDebitoDTO> getValorTotalDebito(@PathVariable Long tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.getValorTotalDebito(tipoCadastro, cadastroGeral));
    }

    @GetMapping(value={"/{id}/parcelamentos/info"})
    public ResponseEntity<AtendimentoInformacaoDashDebitoDTO> getValorTotalParcelamentos(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.atendimentoService.getValorTotalParcelamentos(id));
    }

    @GetMapping(value={"/search-contribuinte"})
    public ResponseEntity<Page<AtendimentoPessoaDTO>> searchPessoa(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchPessoa(search, pageable));
    }

    @PostMapping(value={"/search-cadastros-geral"})
    public ResponseEntity<CadastroGeralSearchDTO> searchCadastros(Pageable pageable, @RequestBody CadastroGeralSearchParamsDTO searchParams) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchCadastros(searchParams, pageable));
    }

    @PostMapping(value={"/advanced-search"})
    public ResponseEntity<CadastroGeralSearchDTO> advancedSearch(Pageable pageable, @RequestBody AdvancedSearchParamsDTO searchParams) {
        return ResponseEntity.ok((Object)this.atendimentoService.advancedSearchCadastros(searchParams, pageable));
    }

    @PostMapping(value={"/search-cadastros/by-pessoa/{idPessoa}"})
    public ResponseEntity<CadastroGeralSearchDTO> searchCadastrosByPessoa(@PathVariable Long idPessoa, Pageable pageable, @RequestBody List<SelectedFacetDTO> facets) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchCadastrosByPessoa(idPessoa, pageable, facets));
    }

    @PostMapping(value={"/search-cadastros/by-pessoa-cadastro-endereco/{idPessoa}"})
    public ResponseEntity<CadastroGeralSearchDTO> searchCadastrosByPessoaAndCadastroOrEndereco(@PathVariable Long idPessoa, @RequestParam String search, Pageable pageable, @RequestBody List<SelectedFacetDTO> facets) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchCadastrosByPessoaAndCadastroOrEndereco(idPessoa, search, pageable, facets));
    }

    @PostMapping
    public ResponseEntity<AtendimentoDTO> save(@RequestBody @Valid AtendimentoDTO atendimento) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.atendimentoService.save(atendimento));
    }

    @PutMapping(value={"/{idAtendimento}/trocar-cadastro/{idCadastro}"})
    public ResponseEntity<AtendimentoDTO> update(@PathVariable Long idAtendimento, @PathVariable Long idCadastro) {
        Atendimento atendimentoUpdated = this.atendimentoService.trocaCadastro(idAtendimento, idCadastro);
        return ResponseEntity.ok((Object)AtendimentoDTO.from((Atendimento)atendimentoUpdated));
    }

    @PutMapping(value={"/{idAtendimento}/finalizar"})
    public ResponseEntity<Void> finalizarAtendimento(@PathVariable Long idAtendimento) {
        this.atendimentoService.finalizarAtendimento(idAtendimento);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idAtendimento}"})
    public ResponseEntity<AtendimentoDTO> loadAtendimento(@PathVariable Long idAtendimento) {
        Optional found = this.atendimentoService.findOne(idAtendimento);
        if (found.isPresent()) {
            return ResponseEntity.ok((Object)AtendimentoDTO.from((Atendimento)((Atendimento)found.get())));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{cadastroGeral}/historicos"})
    public ResponseEntity<List<AtendimentoHistoricoDTO>> loadHistoricos(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.loadHistoricos(cadastroGeral));
    }

    @GetMapping(value={"/current"})
    public ResponseEntity<AtendimentoDTO> loadAtendimentoCurrent() {
        Optional found = this.atendimentoService.loadAtendimentoUser(SecurityUtils.getPreferredUsername());
        if (found.isPresent()) {
            return ResponseEntity.ok((Object)((AtendimentoDTO)found.get()));
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/imprimir-extrato"})
    public void imprimirExtratoDebitos(@RequestBody FiltroExtratoDebitoDTO filtro, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.atendimentoService.imprimirExtratoDebitos(filtro);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o extrato de d\u00e9bitos.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"extrato.pdf");
    }

    @PostMapping(value={"/debitos-contribuinte/{idPessoa}/search-debitos-por-contribuinte"})
    public ResponseEntity<DebitosEmAbertoComTotalizadorDTO> getDebitosContribuinte(@PathVariable Long idPessoa, @RequestBody FiltroDebitoPorContribuinteDTO filtro) {
        List listDebitos = this.debitoEmAbertoService.loadDebitosContribuinte(idPessoa, filtro);
        return ResponseEntity.ok((Object)new DebitosEmAbertoComTotalizadorDTO(listDebitos));
    }

    @GetMapping(value={"/{tipoCadastro}/{cadastroGeral}/execucoes/info"})
    public ResponseEntity<AtendimentoPeticaoDashDTO> getPeticaoAtiva(@PathVariable Long tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.consultaPeticaoAtivo(tipoCadastro, cadastroGeral));
    }

    @GetMapping(value={"/{tipoCadastro}/{cadastroGeral}/pagamentos/info"})
    public ResponseEntity<AtendimentoPagamentoDashDTO> getInfoPagamentos(@PathVariable Long tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.getInfoPagamentos(tipoCadastro, cadastroGeral));
    }

    @Generated
    public AtendimentoResource(AtendimentoService atendimentoService, DebitoEmAbertoService debitoEmAbertoService) {
        this.atendimentoService = atendimentoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
    }
}

