/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.transferenciadebito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.transferenciadebito.FiltroTDDebitoParcelaDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitoParcelaDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TransferenciaDebitoParcelaRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferenciaDebitoParcelaRepository.class);
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String FIND = "br/com/elotech/tributos/repository/transferenciadebito/findDebitosParcelas.sql";
    private static final String FIND_IDS_TO_CHECK_ALL = "br/com/elotech/tributos/repository/transferenciadebito/findDebitosParcelasIdsToCheckAll.sql";

    public Page<TDDebitoParcelaDTO> findDebitosParcelas(FiltroTDDebitoParcelaDTO filtro, Pageable pageable) {
        String where = filtro.buildWhere();
        MapSqlParameterSource params = filtro.buildParams();
        String sql = String.format(FileUtils.readResourceAsString((String)FIND), where);
        Long total = Optional.ofNullable(this.getTotal(sql, params)).orElse(0L);
        String sqlComPaginacao = this.getSqlComPaginacao(sql, pageable);
        log.debug("findDebitosParcelas - SQL utilizado na busca das parcelas (paginado): {}", (Object)sqlComPaginacao);
        log.debug("findDebitosParcelas - Par\u00e2metros utilizados na busca das parcelas: {}", (Object)params.getValues());
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(TDDebitoParcelaDTO.class));
        return new PageImpl(pagedRows, pageable, total.longValue());
    }

    public List<Long> findDebitosParcelasToCheckAll(FiltroTDDebitoParcelaDTO filtro) {
        String where = filtro.buildWhere();
        MapSqlParameterSource params = filtro.buildParams();
        String sql = String.format(FileUtils.readResourceAsString((String)FIND_IDS_TO_CHECK_ALL), where);
        log.debug("findDebitosParcelasToCheckAll - SQL utilizado: {}", (Object)sql);
        log.debug("findDebitosParcelasToCheckAll - Par\u00e2metros utilizados: {}", (Object)params.getValues());
        return this.jdbcTemplate.queryForList(sql, (SqlParameterSource)params, Long.class);
    }

    private Long getTotal(String sql, MapSqlParameterSource params) {
        String sqlCount = String.format("select count(*) as total from (%s) count_query", sql);
        return (Long)this.jdbcTemplate.queryForObject(sqlCount, (SqlParameterSource)params, (rs, rowNum) -> rs.getLong("total"));
    }

    private String getSqlComPaginacao(String sql, Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    @Generated
    public TransferenciaDebitoParcelaRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

