/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.rol;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.rol.GeraRolDTO;
import br.com.elotech.tributos.dto.rol.RolDebitoParcelaTributoDTO;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class GeraRolRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeraRolRepository.class);
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String EXERCICIO = "exercicio";
    private static final String FIND_EXERCICIOS = "br/com/elotech/tributos/repository/rol/findExercicios.sql";
    private static final String INSERT_DEBITOS = "br/com/elotech/tributos/repository/rol/insertDebitos.sql";
    private static final String INSERT_PARCELAS = "br/com/elotech/tributos/repository/rol/insertParcelas.sql";
    private static final String FIND_TRIBUTOS = "br/com/elotech/tributos/repository/rol/findTributos.sql";
    private static final String INSERT_TRIBUTOS = "br/com/elotech/tributos/repository/rol/insertTributos.sql";
    private static final String INSERT_TRIBUTOS_SEM_ACRESCIMOS = "br/com/elotech/tributos/repository/rol/insertTributosSemAcrescimos.sql";

    public List<Long> findExercicios(GeraRolDTO dto) {
        String where = dto.buildWhereOnlyDebito();
        String sql = String.format(FileUtils.readResourceAsString((String)FIND_EXERCICIOS), where);
        MapSqlParameterSource params = dto.buildParams();
        log.debug("findExercicios - SQL utilizado para buscar os exerc\u00edcios pass\u00edveis para o rol de d\u00edvidas: {}", (Object)sql);
        log.debug("findExercicios - Par\u00e2metros utilizados para buscar os exerc\u00edcios pass\u00edveis para o rol de d\u00edvidas: {}", (Object)params.getValues());
        return this.jdbcTemplate.queryForList(sql, (SqlParameterSource)params, Long.class);
    }

    public int insertDebitos(GeraRolDTO dto, Long exercicio) {
        String where = dto.buildWhere();
        String sql = String.format(FileUtils.readResourceAsString((String)INSERT_DEBITOS), where);
        MapSqlParameterSource params = dto.buildParams();
        params.addValue(EXERCICIO, (Object)exercicio);
        log.debug("insertDebitos - SQL utilizado para inserir os d\u00e9bitos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)sql);
        log.debug("insertDebitos - Par\u00e2metros utilizados para inserir os d\u00e9bitos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)params.getValues());
        int rows = this.jdbcTemplate.update(sql, (SqlParameterSource)params);
        log.debug("{} d\u00e9bitos inseridos ao gerar o rol de d\u00edvidas para o exerc\u00edcio {}", (Object)rows, (Object)exercicio);
        return rows;
    }

    public int insertParcelas(GeraRolDTO dto, Long exercicio) {
        String where = dto.buildWhere();
        String sql = String.format(FileUtils.readResourceAsString((String)INSERT_PARCELAS), where);
        MapSqlParameterSource params = dto.buildParams();
        params.addValue(EXERCICIO, (Object)exercicio);
        log.debug("insertParcelas - SQL utilizado para inserir as parcelas do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)sql);
        log.debug("insertParcelas - Par\u00e2metros utilizados para inserir as parcelas do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)params.getValues());
        int rows = this.jdbcTemplate.update(sql, (SqlParameterSource)params);
        log.debug("{} parcelas inseridas ao gerar o rol de d\u00edvidas para o exerc\u00edcio {}", (Object)rows, (Object)exercicio);
        return rows;
    }

    public List<RolDebitoParcelaTributoDTO> findTributos(GeraRolDTO dto, Long exercicio) {
        String where = dto.buildWhere();
        MapSqlParameterSource params = dto.buildParams();
        String sql = String.format(FileUtils.readResourceAsString((String)FIND_TRIBUTOS), where);
        params.addValue(EXERCICIO, (Object)exercicio);
        log.debug("findTributos - SQL utilizado para buscar os tributos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)sql);
        log.debug("findTributos - Par\u00e2metros utilizados para buscar os tributos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)params.getValues());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(RolDebitoParcelaTributoDTO.class));
    }

    public int insertTributosComAcrescimos(String insertValues, Long exercicio) {
        String sql = String.format(FileUtils.readResourceAsString((String)INSERT_TRIBUTOS), insertValues);
        log.debug("insertTributos - SQL utilizado para inserir os d\u00e9bitos/parcelas/tributos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)sql);
        int rows = this.jdbcTemplate.update(sql, new HashMap());
        log.debug("{} d\u00e9bitos/parcelas/tributos inseridos ao gerar o rol de d\u00edvidas para o exerc\u00edcio {}", (Object)rows, (Object)exercicio);
        return rows;
    }

    public int insertTributosSemAcrescimos(GeraRolDTO dto, Long exercicio) {
        String where = dto.buildWhere();
        String sql = String.format(FileUtils.readResourceAsString((String)INSERT_TRIBUTOS_SEM_ACRESCIMOS), where);
        MapSqlParameterSource params = dto.buildParams();
        params.addValue(EXERCICIO, (Object)exercicio);
        log.debug("insertTributosSemAcrescimos - SQL utilizado para inserir os d\u00e9bitos/parcelas/tributos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)sql);
        log.debug("insertTributosSemAcrescimos - Par\u00e2metros utilizados para inserir os d\u00e9bitos/parcelas/tributos do rol de d\u00edvidas para o exerc\u00edcio {}: {}", (Object)exercicio, (Object)params.getValues());
        int rows = this.jdbcTemplate.update(sql, (SqlParameterSource)params);
        log.debug("{} d\u00e9bitos/parcelas/tributos inseridos ao gerar o rol de d\u00edvidas para o exerc\u00edcio {}", (Object)rows, (Object)exercicio);
        return rows;
    }

    @Generated
    public GeraRolRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

