/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.RastreamentoProprietarioDTO;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RastreamentoRepository {
    private static final String SQL_RASTREAMENTO = "br/com/elotech/tributos/repository/rastreamento.sql";
    private static final String SQL_RASTREAMENTO_DEVEDOR_SOLIDARIO = "br/com/elotech/tributos/repository/rastreamento-devedor-solidario.sql";
    private static final String SQL_RASTREAMENTO_DEBITOS = "br/com/elotech/tributos/repository/rastreamento-debitos.sql";
    private static final String SQL_RASTREAMENTO_CADASTROS_SOCIOS = "br/com/elotech/tributos/repository/rastreamento-busca-cadastros-socios.sql";
    private static final String SQL_RASTREAMENTO_BUSCA_SOCIOS = "br/com/elotech/tributos/repository/rastreamento-busca-socios.sql";
    private static final String SQL_RASTREAMENTO_CONTRATO_SOCIAL = "br/com/elotech/tributos/repository/rastreamento-contrato-social.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public RastreamentoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<RastreamentoProprietarioDTO> loadRastreamentoPorCadastro(Long id, Boolean consideraAvulso) {
        return this.loadRastreamento(this.mountFiltroPorCadastro(id), consideraAvulso);
    }

    public List<RastreamentoProprietarioDTO> loadRastreamentoPorCpfCnpj(String cpfCnpj, Boolean consideraAvulso, Boolean consideraCnpjRaiz) {
        return this.loadRastreamento(this.mountFiltroPorCpfCnpj(cpfCnpj, consideraCnpjRaiz), consideraAvulso);
    }

    private List<RastreamentoProprietarioDTO> loadRastreamento(String filtro, Boolean consideraAvulso) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO).replaceAll(":filtroRastreamento", filtro);
        List tiposCadastros = this.tipoCadastrosConsiderados(consideraAvulso);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tiposCadastroExcetoImobiliario", tiposCadastros.stream().filter(tipo -> !TipoCadastro.IMOBILIARIO.getValue().equals(tipo)).collect(Collectors.toList()));
        parameters.addValue("tiposCadastro", (Object)tiposCadastros);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }

    private String mountFiltroPorCadastro(Long id) {
        return String.format(" and (a.idKey = %d) ", id);
    }

    private String mountFiltroPorCpfCnpj(String cpfCnpj, Boolean consideraCnpjRaiz) {
        if (this.isCpf(cpfCnpj).booleanValue()) {
            return String.format("  and (b.cnpj_cpf = '%s' and b.tipopessoa = 'F')", cpfCnpj);
        }
        if (consideraCnpjRaiz.booleanValue()) {
            return String.format("  and (substr(b.cnpj_cpf, 1, 8) = '%s' and b.tipopessoa = 'J')", this.truncCnpj(cpfCnpj));
        }
        return String.format("  and (b.cnpj_cpf = '%s' and b.tipopessoa = 'J')", cpfCnpj);
    }

    private List<Long> tipoCadastrosConsiderados(Boolean consideraAvulso) {
        if (consideraAvulso.booleanValue()) {
            return Arrays.asList(TipoCadastro.IMOBILIARIO.getValue(), TipoCadastro.MOBILIARIO.getValue(), TipoCadastro.RURAL.getValue(), TipoCadastro.CEMITERIO.getValue(), TipoCadastro.AVULSO.getValue());
        }
        return Arrays.asList(TipoCadastro.IMOBILIARIO.getValue(), TipoCadastro.MOBILIARIO.getValue(), TipoCadastro.RURAL.getValue(), TipoCadastro.CEMITERIO.getValue());
    }

    public List<RastreamentoDebitoDTO> loadDebitosRastreamento(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_DEBITOS);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoDebitoDTO.class));
    }

    public List<RastreamentoProprietarioDTO> loadRastreamentoDevedorSolidarioPorCadastro(Long id) {
        return this.loadRastreamentoDevedorSolidario(this.mountFiltroPorCadastro(id));
    }

    public List<RastreamentoProprietarioDTO> loadRastreamentoDevedorSolidarioPorCpfCnpj(String cnpjCpf, Boolean consideraCnpjRaiz) {
        return this.loadRastreamentoDevedorSolidario(this.mountFiltroPorCpfCnpj(cnpjCpf, consideraCnpjRaiz));
    }

    private List<RastreamentoProprietarioDTO> loadRastreamentoDevedorSolidario(String filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_DEVEDOR_SOLIDARIO) + filtro;
        return this.jdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }

    private Boolean isCpf(String cpfCnpj) {
        return cpfCnpj.length() <= 11;
    }

    private String truncCnpj(String cnpj) {
        return cnpj.substring(0, Math.min(8, cnpj.length()));
    }

    public Set<RastreamentoCadastroDTO> loadRastreamentoCadastrosSocios(String cnpjCpf, Boolean consideraCnpjRaiz, Boolean consideraAvulso) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_CADASTROS_SOCIOS).replaceAll(":filtroRastreamento", this.mountFiltroPorCpfCnpj(cnpjCpf, consideraCnpjRaiz));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tiposCadastro", (Object)this.tipoCadastrosConsiderados(consideraAvulso));
        return RastreamentoCadastroDTO.agruparPorCadastro((List)this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class)));
    }

    public List<RastreamentoProprietarioDTO> buscaSocios(Long idCadastro) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_BUSCA_SOCIOS);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idCadastro", (Object)idCadastro);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }

    public List<RastreamentoProprietarioDTO> loadRastreamentoContratoSocialPorCpfCnpj(String cpfCnpj, Boolean consideraCnpjRaiz) {
        return this.loadRastreamentoContratoSocial(this.mountFiltroPorCpfCnpj(cpfCnpj, consideraCnpjRaiz));
    }

    private List<RastreamentoProprietarioDTO> loadRastreamentoContratoSocial(String filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_RASTREAMENTO_CONTRATO_SOCIAL).replace(":filtroRastreamento", filtro);
        return this.jdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(RastreamentoProprietarioDTO.class));
    }
}

