/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.movimentacaodiaria.MovimentacaoDiaria;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MovimentacaoDiariaRepository
extends CrudRepository<MovimentacaoDiaria, MovimentacaoDiariaId> {
    @Query(value="select tmd   from MovimentacaoDiaria tmd  where tmd.id.entidade = :entidade    and tmd.id.data >= :dataInicio    and tmd.id.data <= :dataFim  order by tmd.id.data ")
    public List<MovimentacaoDiaria> findSituacaoByMesAno(@Param(value="entidade") Long var1, @Param(value="dataInicio") LocalDate var2, @Param(value="dataFim") LocalDate var3);

    @Query(value="select tmd  from MovimentacaoDiaria tmd  where tmd.id.entidade = :entidade  and tmd.id.data = :data ")
    public MovimentacaoDiaria findSituacaoByDataMovimento(@Param(value="entidade") Long var1, @Param(value="data") LocalDate var2);

    @Query(value="select  case when count(1) > 0 then true else false end   from MovimentacaoDiaria tmd  where tmd.id.entidade = :entidade    and tmd.id.data >= :dataInicio    and tmd.id.data <= :dataFim    and tmd.situacao != :situacao ")
    public Boolean existsByPeriodoAndSituacaoDiferente(@Param(value="entidade") Long var1, @Param(value="dataInicio") LocalDate var2, @Param(value="dataFim") LocalDate var3, @Param(value="situacao") SituacaoMovimentacaoDiaria var4);
}

