/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EnderecoCorrespondenciaRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public EnderecoCorrespondenciaRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public EnderecoCorrespondenciaDTO findEnderecoCorrespondenciaByIdAndTipo(Long id, TipoEnderecoCorrespondencia tipoEndereco) {
        String enderecoFromId = "SELECT IDKEY AS ID, TIPOCADASTRO, CADASTROGERAL, TIPOENDERECOCORRESPONDENCIA, CEP, LOGRADOURO, LOGRADOURODESCRICAO, LOGRADOUROTIPO, NUMERO, BAIRRO, BAIRRODESCRICAO, CIDADE, CIDADEDESCRICAO, COMPLEMENTO, UNIDADEFEDERACAO, PESSOA FROM ENDERECOCORRESPONDENCIA WHERE IDKEY = :id AND TIPOENDERECOCORRESPONDENCIA = :tipoEndereco";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        parameters.addValue("tipoEndereco", (Object)tipoEndereco.getValue());
        return (EnderecoCorrespondenciaDTO)this.jdbcTemplate.queryForObject("SELECT IDKEY AS ID, TIPOCADASTRO, CADASTROGERAL, TIPOENDERECOCORRESPONDENCIA, CEP, LOGRADOURO, LOGRADOURODESCRICAO, LOGRADOUROTIPO, NUMERO, BAIRRO, BAIRRODESCRICAO, CIDADE, CIDADEDESCRICAO, COMPLEMENTO, UNIDADEFEDERACAO, PESSOA FROM ENDERECOCORRESPONDENCIA WHERE IDKEY = :id AND TIPOENDERECOCORRESPONDENCIA = :tipoEndereco", (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EnderecoCorrespondenciaDTO.class));
    }

    public EnderecoCorrespondenciaDTO findEnderecoCorrespondenciaPessoa(Long idPessoa) {
        String enderecoPessoa = String.format("SELECT '%s' AS TIPOENDERECOCORRESPONDENCIA, CAST(EP.CEP AS VARCHAR(10)) AS CEP, L.LOGRADOURO, L.DESCRICAO AS LOGRADOURODESCRICAO, TL.DESCRICAO AS LOGRADOUROTIPO, CAST(EP.NUMERO AS VARCHAR(10)) AS NUMERO, B.BAIRRO, B.DESCRICAO AS BAIRRODESCRICAO, C.CIDADE, C.DESCRICAO AS CIDADEDESCRICAO, EP.COMPLEMENTO, UF.UNIDADEFEDERACAO, P.PESSOA FROM PESSOA P LEFT OUTER JOIN ENDERECOPESSOA EP ON EP.PESSOA = P.PESSOA AND EP.SEQUENCIA = P.SEQUENCIAENDERECO LEFT OUTER JOIN LOGRADOURO L ON L.IDKEY = EP.LOGRADOURO_IDKEY LEFT OUTER JOIN TIPOLOGRADOURO TL ON L.TIPOLOGRADOURO = TL.TIPOLOGRADOURO LEFT OUTER JOIN BAIRRO B ON B.IDKEY = EP.BAIRRO_IDKEY LEFT OUTER JOIN CIDADE C ON C.CIDADE = EP.CIDADE LEFT OUTER JOIN UNIDADEFEDERACAO UF ON UF.IDKEY = C.UNIDADEFEDERACAO_IDKEY  WHERE P.PESSOA = :idPessoa", TipoEnderecoCorrespondencia.ENDERECO_PESSOA.name());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idPessoa", (Object)idPessoa);
        return (EnderecoCorrespondenciaDTO)this.jdbcTemplate.queryForObject(enderecoPessoa, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EnderecoCorrespondenciaDTO.class));
    }
}

