/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.repository.DebitoEmAbertoDTORowMapper;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroDebitoPorContribuinteDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoEmAbertoRepository {
    private static final String SQL_DEBITOS = "br/com/elotech/tributos/repository/find-debito-aberto.sql";
    private static final String SQL_DEBITOS_COM_CDA_ORIGEM = "br/com/elotech/tributos/repository/find-debito-aberto-cda-debito-origem.sql";
    private static final String SQL_EXTRATO_DEBITOS = "br/com/elotech/tributos/repository/extrato-debito-contribuinte.sql";
    private static final String FIND_DEBITO_SUPERBOLETO = "br/com/elotech/tributos/repository/find-debitos-por-contribuinte.sql";
    private static final String FIND_DEBITO_PAGAMENTO_NEGOCIADO = "br/com/elotech/tributos/repository/find-debitos-de-pagamento-negociado.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ContextService contextService;
    private final ParametroGeralService parametroGeralService;

    public List<DebitoEmAbertoDTO> findDebitosPorContribuinte(Long entidade, Long exercicio, FormaPagamento padrao, Long idPessoa, FiltroDebitoPorContribuinteDTO filtro) {
        String sql = FileUtils.readResourceAsString((String)FIND_DEBITO_SUPERBOLETO);
        sql = sql.replace(":Filtro", filtro.buildFilter());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (Objects.nonNull(filtro.getDataVencimentoInicial())) {
            parameters.addValue("datavencimentoinicial", (Object)filtro.getDataVencimentoInicial());
        }
        if (Objects.nonNull(filtro.getDataVencimentoFinal())) {
            parameters.addValue("datavencimentofinal", (Object)filtro.getDataVencimentoFinal());
        }
        parameters.addValue("DATAATUAL", (Object)LocalDate.now());
        parameters.addValue("Exercicio", (Object)exercicio);
        parameters.addValue("idPessoa", (Object)idPessoa);
        parameters.addValue("Entidade", (Object)entidade);
        parameters.addValue("formapagamento", (Object)padrao.getId());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoEmAbertoDTO.class));
    }

    public List<DebitoEmAbertoDTO> loadDebitoEmAberto(String filtro, Boolean geraBoletoSomenteConstituidos) {
        Boolean utilizaConsultaComCda = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_CONSULTA_DEBITOS_CDA_DEBITO_ORIGEM);
        String sql = Boolean.TRUE.equals(utilizaConsultaComCda) ? FileUtils.readResourceAsString((String)SQL_DEBITOS_COM_CDA_ORIGEM) : FileUtils.readResourceAsString((String)SQL_DEBITOS);
        StringBuilder filtrosSql = new StringBuilder().append(" and ( ").append(filtro).append(" ) ");
        if (geraBoletoSomenteConstituidos.booleanValue()) {
            filtrosSql.append(" and TRIBDEBITO.CONSTITUIDO = 'S'");
        }
        String finalSql = sql.replace("[FILTER]", filtrosSql.toString());
        return this.jdbcTemplate.query(finalSql, (RowMapper)new DebitoEmAbertoDTORowMapper());
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFilter(String filtro) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXTRATO_DEBITOS) + filtro;
        return this.jdbcTemplate.query(sql.replace("$[FILTROTODOSCADASTROS]", "0 as FILTROTODOSCADASTROS"), (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new ElotechBeanPropertyRowMapper(ExtratoDebitoDTO.class));
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFiltro(FiltroExtratoDebitoDTO filtro, Boolean visualizaDebitosNaoConstituidos) {
        filtro.setVisualizaDebitosNaoConstituidos(visualizaDebitosNaoConstituidos);
        String sql = FileUtils.readResourceAsString((String)SQL_EXTRATO_DEBITOS).replace("$[FILTROTODOSCADASTROS]", filtro.getTodosCadastros() != false ? "1 as FILTROTODOSCADASTROS" : "0 as FILTROTODOSCADASTROS") + " ( " + filtro.buildFilter() + " )  ORDER BY TD.IDDEBITO, TDP.PARCELA ";
        return this.jdbcTemplate.query(sql, (SqlParameterSource)this.getParameterSource(filtro), (RowMapper)new ElotechBeanPropertyRowMapper(ExtratoDebitoDTO.class));
    }

    public List<DebitoPagamentoNegociadoDTO> loadDebitosPagamentoNegociado(FiltroConsultaDebitoPagamentoNegociado filtro, Long entidadePrincipal) {
        String sql = FileUtils.readResourceAsString((String)FIND_DEBITO_PAGAMENTO_NEGOCIADO);
        sql = sql.replace(":Filtros", filtro.generateWhereClause());
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("ENTIDADEPRINCIPAL", (Object)entidadePrincipal);
        parameter.addValue("DATAVENCIMENTOINICIAL", (Object)filtro.getDataVencimentoInicial());
        parameter.addValue("DATAVENCIMENTOFINAL", (Object)filtro.getDataVencimentoFinal());
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoPagamentoNegociadoDTO.class));
    }

    private MapSqlParameterSource getParameterSource(FiltroExtratoDebitoDTO filtro) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("DATAATUAL", (Object)Date.valueOf(this.contextService.getDataAtual()));
        if (Objects.nonNull(filtro.getDataLancamentoInicial())) {
            params.addValue("DATALANCAMENTOINICIAL", (Object)filtro.getDataLancamentoInicial());
        }
        if (Objects.nonNull(filtro.getDataLancamentoFinal())) {
            params.addValue("DATALANCAMENTOFINAL", (Object)filtro.getDataLancamentoFinal());
        }
        if (Objects.nonNull(filtro.getDataVencimentoInicial())) {
            params.addValue("DATAVENCIMENTOINICIAL", (Object)filtro.getDataVencimentoInicial());
        }
        if (Objects.nonNull(filtro.getDataVencimentoFinal())) {
            params.addValue("DATAVENCIMENTOFINAL", (Object)filtro.getDataVencimentoFinal());
        }
        return params;
    }

    @Generated
    public DebitoEmAbertoRepository(NamedParameterJdbcTemplate jdbcTemplate, ContextService contextService, ParametroGeralService parametroGeralService) {
        this.jdbcTemplate = jdbcTemplate;
        this.contextService = contextService;
        this.parametroGeralService = parametroGeralService;
    }
}

