/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.repository.CadastroGeralCustomRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CadastroGeralRepository
extends CrudRepository<CadastroGeral, Long>,
CadastroGeralCustomRepository {
    public Boolean existsByTipoCadastroAndCadastroGeral(TipoCadastro var1, Long var2);

    public List<CadastroGeral> findByPessoaCnpjCpfAndExclusaoLogicaFalse(String var1);

    public Optional<CadastroGeral> findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(TipoCadastro var1, Long var2);

    @Query(value="select cg.proprietarios from CadastroGeral cg where cg.id = :id and cg.exclusaoLogica = false ")
    public List<Proprietario> findProprietariosById(@Param(value="id") Long var1);

    public List<CadastroGeral> findByPessoaIdAndTipoCadastroAndExclusaoLogicaFalseOrderByCadastroGeralAsc(Long var1, TipoCadastro var2);

    @Query(value="SELECT CASE WHEN EXISTS(SELECT 1                          FROM TRIBDEBITO DEB                          INNER JOIN TRIBDEBITOPARCELA PAR ON DEB.ENTIDADE = PAR.ENTIDADE                                                          AND DEB.EXERCICIO = PAR.EXERCICIO                                                          AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO                                                          AND DEB.CADASTROGERAL = PAR.CADASTROGERAL                                                          AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO                                                          AND DEB.SUBDIVIDA = PAR.SUBDIVIDA                          INNER JOIN TRIBSITUACAOPARCELA SIT ON PAR.SITUACAODEBITO = SIT.SITUACAOPARCELA                          INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON SIT.SITUACAOPARCELA = TIP.TIPOSITUACAOPARCELA                          WHERE DEB.TIPOCADASTRO = CG.TIPOCADASTRO                            AND DEB.CADASTROGERAL = CG.CADASTROGERAL                            AND DEB.CONSTITUIDO = 'S'                            AND TIP.TIPOSITUACAOPARCELA = 1                            AND PAR.DATAVENCIMENTO < CURRENT_DATE         ) THEN 'true' ELSE 'false' END AS VENCIDO FROM TRIBCADASTROGERAL CG  WHERE CG.EXCLUSAOLOGICA = 'N' AND CG.IDKEY = :idCadastro ", nativeQuery=true)
    public Boolean hasDebitoVencido(@Param(value="idCadastro") Long var1);

    public Boolean existsByTipoCadastroAndPessoaCnpjCpfAndExclusaoLogicaFalse(TipoCadastro var1, String var2);

    @Query(value="select new br.com.elotech.tributos.dto.CadastroGeralResumidoDTO(cgp.tipoCadastro, cgp.cadastroGeral) from CadastroGeral cg  join Pessoa p on cg.pessoa = p.id  join CadastroGeral cgp on cgp.pessoa = p.id  where cg.tipoCadastro = :tipoCadastro and cg.cadastroGeral = :cadastroGeral and cg.exclusaoLogica = false")
    public List<CadastroGeralResumidoDTO> findCadastrosPessoa(@Param(value="tipoCadastro") TipoCadastro var1, @Param(value="cadastroGeral") Long var2);

    public Optional<CadastroGeral> findByCadastroGeralISS(Long var1);
}

