/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ExercicioService;
import org.springframework.stereotype.Component;

@Component
public class EspelhoMobiliarioParamLoader {
    private static final String PARAM_FORMAT = "%s=%s%n";
    private static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    private static final String PARAM_DESC_UF = "PDescUF";
    private static final String PARAM_EXERCICIO = "PExercicio";
    private static final String PARAM_MASK_CNPJ = "PMaskCNPJ";
    private static final String PARAM_MASK_FONE = "PMaskFone";
    private static final String MASCARA_CNPJ = "XX.XXX.XXX/XXXX-XX";
    private static final String MASCARA_FONE = "(XX)XXXX-XXXX";
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;

    public EspelhoMobiliarioParamLoader(EntidadeRepository entidadeRepository, ExercicioService exercicioService) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
    }

    public String load() {
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return String.format(PARAM_FORMAT, PARAM_NOME_ENTIDADE, entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, PARAM_DESC_UF, unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, PARAM_EXERCICIO, exercicio)).concat(String.format(PARAM_FORMAT, PARAM_MASK_CNPJ, MASCARA_CNPJ)).concat(String.format(PARAM_FORMAT, PARAM_MASK_FONE, MASCARA_FONE));
    }
}

