/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.notification;

import br.com.elotech.client.painel.feign.NotificationWebSocketFeign;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.WebSocketMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationHandler.class);
    private final Optional<NotificationWebSocketFeign> notificationWebSocketFeign;
    private final ObjectMapper objectMapper;

    protected void notify(String topic, Object message) {
        if (this.notificationWebSocketFeign.isEmpty()) {
            throw new EloValidationException("A notifica\u00e7\u00e3o via websocket n\u00e3o est\u00e1 disponivel no ambiente onpremise.");
        }
        try {
            ((NotificationWebSocketFeign)this.notificationWebSocketFeign.get()).webSocketMessage(WebSocketMessage.builder().topic(topic).payload(this.objectMapper.writeValueAsString(message)).build());
        }
        catch (JsonProcessingException | FeignException e) {
            log.error("Ocorreu um erro ao notificar o painel", e);
        }
    }

    @Generated
    public NotificationHandler(Optional<NotificationWebSocketFeign> notificationWebSocketFeign, ObjectMapper objectMapper) {
        this.notificationWebSocketFeign = notificationWebSocketFeign;
        this.objectMapper = objectMapper;
    }
}

