/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.simam.validacaoimportacao;

import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.InscricaoDividaAtivaValidacao;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class InscricaoDividaAtivaValidacao {
    private static final Long CODIGO_ESCOPO_LEI = 22L;
    private static final Set<TipoOperacaoCredito> TipoOperacaoCreditoSimAm = Arrays.stream(TipoOperacaoCredito.values()).collect(Collectors.toSet());
    private static final long EXERCICIO_VALIDO = 2023L;
    private Long idTceInscCreditoDa;
    private Long nrAnoInscricao;
    private LocalDate dtInscricao;
    private BigDecimal vlInscricao;
    private Long idTipoOperacaoCredito;
    private Long idTipoNaturezaCredito;
    private Integer idTipoCredito;
    private Long nrDivida;
    private Long nrAnoDivida;
    private Long nrCredito;
    private Long nrAnoCredito;
    private LocalDate dtLancamento;
    private Long nrAnoBase;
    private Long nrMesBase;
    private Long quantidadeRegistroNrDivida;
    private Long quantidadeRegistroCredito;
    private Long escopoLei;
    private Long cdControleLeiAto;
    private Long nrDividaAnterior;
    private TipoOperacaoCredito currentTipoOperacaoCredito;
    private TipoNaturezaCredito currentTipoNaturezaCredito;
    private ClassificacaoTipoTributo currentTipoCredito;
    private boolean isTipoOperacaoCreditoValida;

    public void loadInformacoesAdicionais() {
        this.currentTipoOperacaoCredito = TipoOperacaoCredito.fromValue((Long)this.idTipoOperacaoCredito);
        this.currentTipoNaturezaCredito = TipoNaturezaCredito.fromValue((Long)this.idTipoNaturezaCredito);
        this.currentTipoCredito = ClassificacaoTipoTributo.fromValue((Integer)this.idTipoCredito);
        this.isTipoOperacaoCreditoValida = TipoOperacaoCreditoSimAm.contains(this.currentTipoOperacaoCredito);
    }

    public boolean isDuplicado() {
        return this.quantidadeRegistroNrDivida > 1L;
    }

    public boolean isSequenciaValida() {
        return this.nrDivida == null || this.nrDividaAnterior == 0L || this.nrDivida - this.nrDividaAnterior == 1L;
    }

    public boolean isTipoOperacaoCreditoValida() {
        return this.isTipoOperacaoCreditoValida && (TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES.equals((Object)this.currentTipoOperacaoCredito) || TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA.equals((Object)this.currentTipoOperacaoCredito));
    }

    public boolean isInscricaoEmDividaAtivaSemNrCreditoESemNrAnoCredito() {
        return this.isTipoOperacaoCreditoValida && TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA.equals((Object)this.currentTipoOperacaoCredito) && this.nrCredito != null && this.nrAnoCredito != null;
    }

    public boolean isInscricaoPorImplantacaoDeSaldoOuARestituiDeAnosAnterioresValida() {
        return this.isTipoOperacaoCreditoValida && (TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES.equals((Object)this.currentTipoOperacaoCredito) || TipoOperacaoCredito.DIVIDAS_A_RESTITUIR.equals((Object)this.currentTipoOperacaoCredito)) && this.idTipoNaturezaCredito != null && this.idTipoCredito != null;
    }

    public boolean isTipoCreditoConsolidado() {
        return TipoNaturezaCredito.CREDITO_TRIBUTARIO.equals((Object)this.currentTipoNaturezaCredito) && !Arrays.asList(ClassificacaoTipoTributo.TAXAS, ClassificacaoTipoTributo.COSIP).contains(this.currentTipoCredito) && this.nrDivida != null && this.nrAnoDivida != null;
    }

    public boolean isEscopoMunicipal() {
        return CODIGO_ESCOPO_LEI.equals(this.escopoLei);
    }

    public boolean isInscricaoDepoisDoLancamentoDeCredito() {
        return TipoOperacaoCredito.DIVIDAS_A_RESTITUIR.equals((Object)this.currentTipoOperacaoCredito) || this.dtLancamento != null && !this.dtInscricao.isBefore(this.dtLancamento);
    }

    public boolean isDataDeInscricaoDepoisDoMesProcessado(LocalDate dataProcessamento) {
        return this.dtInscricao.isAfter(dataProcessamento);
    }

    public boolean isValorPositivo() {
        return this.vlInscricao.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isCreditoRepetidoEmImplantacaoDeSaldoOuARestuirDeAnosAnteriores() {
        return this.quantidadeRegistroCredito > 1L && (TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES.equals((Object)this.currentTipoOperacaoCredito) || TipoOperacaoCredito.DIVIDAS_A_RESTITUIR.equals((Object)this.currentTipoOperacaoCredito));
    }

    public boolean isCreditoRepetido() {
        return this.quantidadeRegistroCredito > 1L && TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA.equals((Object)this.currentTipoOperacaoCredito);
    }

    public boolean isImplantacaoDeSaldoValida() {
        return TipoOperacaoCredito.IMPLANTACAO_SALDOS_ANTERIORES.equals((Object)this.currentTipoOperacaoCredito) && this.nrCredito == null && this.nrAnoCredito == null;
    }

    public boolean isInscricaoEmDividaAtivaSemTipoNaturezaCreditoSemTipoCreditoSemNrAnoBase() {
        return TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA.equals((Object)this.currentTipoOperacaoCredito) && this.idTipoNaturezaCredito == null && this.idTipoCredito == null && this.nrAnoBase == null;
    }

    public boolean isNrAnoDividaValido() {
        return this.nrAnoDivida == null || this.nrAnoDivida >= 2023L;
    }

    public boolean isNrAnoCreditoValido() {
        return this.nrAnoCredito == null || this.nrAnoCredito >= 2023L;
    }

    @Generated
    public static InscricaoDividaAtivaValidacaoBuilder builder() {
        return new InscricaoDividaAtivaValidacaoBuilder();
    }

    @Generated
    public Long getIdTceInscCreditoDa() {
        return this.idTceInscCreditoDa;
    }

    @Generated
    public Long getNrAnoInscricao() {
        return this.nrAnoInscricao;
    }

    @Generated
    public LocalDate getDtInscricao() {
        return this.dtInscricao;
    }

    @Generated
    public BigDecimal getVlInscricao() {
        return this.vlInscricao;
    }

    @Generated
    public Long getIdTipoOperacaoCredito() {
        return this.idTipoOperacaoCredito;
    }

    @Generated
    public Long getIdTipoNaturezaCredito() {
        return this.idTipoNaturezaCredito;
    }

    @Generated
    public Integer getIdTipoCredito() {
        return this.idTipoCredito;
    }

    @Generated
    public Long getNrDivida() {
        return this.nrDivida;
    }

    @Generated
    public Long getNrAnoDivida() {
        return this.nrAnoDivida;
    }

    @Generated
    public Long getNrCredito() {
        return this.nrCredito;
    }

    @Generated
    public Long getNrAnoCredito() {
        return this.nrAnoCredito;
    }

    @Generated
    public LocalDate getDtLancamento() {
        return this.dtLancamento;
    }

    @Generated
    public Long getNrAnoBase() {
        return this.nrAnoBase;
    }

    @Generated
    public Long getNrMesBase() {
        return this.nrMesBase;
    }

    @Generated
    public Long getQuantidadeRegistroNrDivida() {
        return this.quantidadeRegistroNrDivida;
    }

    @Generated
    public Long getQuantidadeRegistroCredito() {
        return this.quantidadeRegistroCredito;
    }

    @Generated
    public Long getEscopoLei() {
        return this.escopoLei;
    }

    @Generated
    public Long getCdControleLeiAto() {
        return this.cdControleLeiAto;
    }

    @Generated
    public Long getNrDividaAnterior() {
        return this.nrDividaAnterior;
    }

    @Generated
    public TipoOperacaoCredito getCurrentTipoOperacaoCredito() {
        return this.currentTipoOperacaoCredito;
    }

    @Generated
    public TipoNaturezaCredito getCurrentTipoNaturezaCredito() {
        return this.currentTipoNaturezaCredito;
    }

    @Generated
    public ClassificacaoTipoTributo getCurrentTipoCredito() {
        return this.currentTipoCredito;
    }

    @Generated
    public void setIdTceInscCreditoDa(Long idTceInscCreditoDa) {
        this.idTceInscCreditoDa = idTceInscCreditoDa;
    }

    @Generated
    public void setNrAnoInscricao(Long nrAnoInscricao) {
        this.nrAnoInscricao = nrAnoInscricao;
    }

    @Generated
    public void setDtInscricao(LocalDate dtInscricao) {
        this.dtInscricao = dtInscricao;
    }

    @Generated
    public void setVlInscricao(BigDecimal vlInscricao) {
        this.vlInscricao = vlInscricao;
    }

    @Generated
    public void setIdTipoOperacaoCredito(Long idTipoOperacaoCredito) {
        this.idTipoOperacaoCredito = idTipoOperacaoCredito;
    }

    @Generated
    public void setIdTipoNaturezaCredito(Long idTipoNaturezaCredito) {
        this.idTipoNaturezaCredito = idTipoNaturezaCredito;
    }

    @Generated
    public void setIdTipoCredito(Integer idTipoCredito) {
        this.idTipoCredito = idTipoCredito;
    }

    @Generated
    public void setNrDivida(Long nrDivida) {
        this.nrDivida = nrDivida;
    }

    @Generated
    public void setNrAnoDivida(Long nrAnoDivida) {
        this.nrAnoDivida = nrAnoDivida;
    }

    @Generated
    public void setNrCredito(Long nrCredito) {
        this.nrCredito = nrCredito;
    }

    @Generated
    public void setNrAnoCredito(Long nrAnoCredito) {
        this.nrAnoCredito = nrAnoCredito;
    }

    @Generated
    public void setDtLancamento(LocalDate dtLancamento) {
        this.dtLancamento = dtLancamento;
    }

    @Generated
    public void setNrAnoBase(Long nrAnoBase) {
        this.nrAnoBase = nrAnoBase;
    }

    @Generated
    public void setNrMesBase(Long nrMesBase) {
        this.nrMesBase = nrMesBase;
    }

    @Generated
    public void setQuantidadeRegistroNrDivida(Long quantidadeRegistroNrDivida) {
        this.quantidadeRegistroNrDivida = quantidadeRegistroNrDivida;
    }

    @Generated
    public void setQuantidadeRegistroCredito(Long quantidadeRegistroCredito) {
        this.quantidadeRegistroCredito = quantidadeRegistroCredito;
    }

    @Generated
    public void setEscopoLei(Long escopoLei) {
        this.escopoLei = escopoLei;
    }

    @Generated
    public void setCdControleLeiAto(Long cdControleLeiAto) {
        this.cdControleLeiAto = cdControleLeiAto;
    }

    @Generated
    public void setNrDividaAnterior(Long nrDividaAnterior) {
        this.nrDividaAnterior = nrDividaAnterior;
    }

    @Generated
    public void setCurrentTipoOperacaoCredito(TipoOperacaoCredito currentTipoOperacaoCredito) {
        this.currentTipoOperacaoCredito = currentTipoOperacaoCredito;
    }

    @Generated
    public void setCurrentTipoNaturezaCredito(TipoNaturezaCredito currentTipoNaturezaCredito) {
        this.currentTipoNaturezaCredito = currentTipoNaturezaCredito;
    }

    @Generated
    public void setCurrentTipoCredito(ClassificacaoTipoTributo currentTipoCredito) {
        this.currentTipoCredito = currentTipoCredito;
    }

    @Generated
    public void setTipoOperacaoCreditoValida(boolean isTipoOperacaoCreditoValida) {
        this.isTipoOperacaoCreditoValida = isTipoOperacaoCreditoValida;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InscricaoDividaAtivaValidacao)) {
            return false;
        }
        InscricaoDividaAtivaValidacao other = (InscricaoDividaAtivaValidacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isTipoOperacaoCreditoValida() != other.isTipoOperacaoCreditoValida()) {
            return false;
        }
        Long this$idTceInscCreditoDa = this.getIdTceInscCreditoDa();
        Long other$idTceInscCreditoDa = other.getIdTceInscCreditoDa();
        if (this$idTceInscCreditoDa == null ? other$idTceInscCreditoDa != null : !((Object)this$idTceInscCreditoDa).equals(other$idTceInscCreditoDa)) {
            return false;
        }
        Long this$nrAnoInscricao = this.getNrAnoInscricao();
        Long other$nrAnoInscricao = other.getNrAnoInscricao();
        if (this$nrAnoInscricao == null ? other$nrAnoInscricao != null : !((Object)this$nrAnoInscricao).equals(other$nrAnoInscricao)) {
            return false;
        }
        Long this$idTipoOperacaoCredito = this.getIdTipoOperacaoCredito();
        Long other$idTipoOperacaoCredito = other.getIdTipoOperacaoCredito();
        if (this$idTipoOperacaoCredito == null ? other$idTipoOperacaoCredito != null : !((Object)this$idTipoOperacaoCredito).equals(other$idTipoOperacaoCredito)) {
            return false;
        }
        Long this$idTipoNaturezaCredito = this.getIdTipoNaturezaCredito();
        Long other$idTipoNaturezaCredito = other.getIdTipoNaturezaCredito();
        if (this$idTipoNaturezaCredito == null ? other$idTipoNaturezaCredito != null : !((Object)this$idTipoNaturezaCredito).equals(other$idTipoNaturezaCredito)) {
            return false;
        }
        Integer this$idTipoCredito = this.getIdTipoCredito();
        Integer other$idTipoCredito = other.getIdTipoCredito();
        if (this$idTipoCredito == null ? other$idTipoCredito != null : !((Object)this$idTipoCredito).equals(other$idTipoCredito)) {
            return false;
        }
        Long this$nrDivida = this.getNrDivida();
        Long other$nrDivida = other.getNrDivida();
        if (this$nrDivida == null ? other$nrDivida != null : !((Object)this$nrDivida).equals(other$nrDivida)) {
            return false;
        }
        Long this$nrAnoDivida = this.getNrAnoDivida();
        Long other$nrAnoDivida = other.getNrAnoDivida();
        if (this$nrAnoDivida == null ? other$nrAnoDivida != null : !((Object)this$nrAnoDivida).equals(other$nrAnoDivida)) {
            return false;
        }
        Long this$nrCredito = this.getNrCredito();
        Long other$nrCredito = other.getNrCredito();
        if (this$nrCredito == null ? other$nrCredito != null : !((Object)this$nrCredito).equals(other$nrCredito)) {
            return false;
        }
        Long this$nrAnoCredito = this.getNrAnoCredito();
        Long other$nrAnoCredito = other.getNrAnoCredito();
        if (this$nrAnoCredito == null ? other$nrAnoCredito != null : !((Object)this$nrAnoCredito).equals(other$nrAnoCredito)) {
            return false;
        }
        Long this$nrAnoBase = this.getNrAnoBase();
        Long other$nrAnoBase = other.getNrAnoBase();
        if (this$nrAnoBase == null ? other$nrAnoBase != null : !((Object)this$nrAnoBase).equals(other$nrAnoBase)) {
            return false;
        }
        Long this$nrMesBase = this.getNrMesBase();
        Long other$nrMesBase = other.getNrMesBase();
        if (this$nrMesBase == null ? other$nrMesBase != null : !((Object)this$nrMesBase).equals(other$nrMesBase)) {
            return false;
        }
        Long this$quantidadeRegistroNrDivida = this.getQuantidadeRegistroNrDivida();
        Long other$quantidadeRegistroNrDivida = other.getQuantidadeRegistroNrDivida();
        if (this$quantidadeRegistroNrDivida == null ? other$quantidadeRegistroNrDivida != null : !((Object)this$quantidadeRegistroNrDivida).equals(other$quantidadeRegistroNrDivida)) {
            return false;
        }
        Long this$quantidadeRegistroCredito = this.getQuantidadeRegistroCredito();
        Long other$quantidadeRegistroCredito = other.getQuantidadeRegistroCredito();
        if (this$quantidadeRegistroCredito == null ? other$quantidadeRegistroCredito != null : !((Object)this$quantidadeRegistroCredito).equals(other$quantidadeRegistroCredito)) {
            return false;
        }
        Long this$escopoLei = this.getEscopoLei();
        Long other$escopoLei = other.getEscopoLei();
        if (this$escopoLei == null ? other$escopoLei != null : !((Object)this$escopoLei).equals(other$escopoLei)) {
            return false;
        }
        Long this$cdControleLeiAto = this.getCdControleLeiAto();
        Long other$cdControleLeiAto = other.getCdControleLeiAto();
        if (this$cdControleLeiAto == null ? other$cdControleLeiAto != null : !((Object)this$cdControleLeiAto).equals(other$cdControleLeiAto)) {
            return false;
        }
        Long this$nrDividaAnterior = this.getNrDividaAnterior();
        Long other$nrDividaAnterior = other.getNrDividaAnterior();
        if (this$nrDividaAnterior == null ? other$nrDividaAnterior != null : !((Object)this$nrDividaAnterior).equals(other$nrDividaAnterior)) {
            return false;
        }
        LocalDate this$dtInscricao = this.getDtInscricao();
        LocalDate other$dtInscricao = other.getDtInscricao();
        if (this$dtInscricao == null ? other$dtInscricao != null : !((Object)this$dtInscricao).equals(other$dtInscricao)) {
            return false;
        }
        BigDecimal this$vlInscricao = this.getVlInscricao();
        BigDecimal other$vlInscricao = other.getVlInscricao();
        if (this$vlInscricao == null ? other$vlInscricao != null : !((Object)this$vlInscricao).equals(other$vlInscricao)) {
            return false;
        }
        LocalDate this$dtLancamento = this.getDtLancamento();
        LocalDate other$dtLancamento = other.getDtLancamento();
        if (this$dtLancamento == null ? other$dtLancamento != null : !((Object)this$dtLancamento).equals(other$dtLancamento)) {
            return false;
        }
        TipoOperacaoCredito this$currentTipoOperacaoCredito = this.getCurrentTipoOperacaoCredito();
        TipoOperacaoCredito other$currentTipoOperacaoCredito = other.getCurrentTipoOperacaoCredito();
        if (this$currentTipoOperacaoCredito == null ? other$currentTipoOperacaoCredito != null : !this$currentTipoOperacaoCredito.equals(other$currentTipoOperacaoCredito)) {
            return false;
        }
        TipoNaturezaCredito this$currentTipoNaturezaCredito = this.getCurrentTipoNaturezaCredito();
        TipoNaturezaCredito other$currentTipoNaturezaCredito = other.getCurrentTipoNaturezaCredito();
        if (this$currentTipoNaturezaCredito == null ? other$currentTipoNaturezaCredito != null : !this$currentTipoNaturezaCredito.equals(other$currentTipoNaturezaCredito)) {
            return false;
        }
        ClassificacaoTipoTributo this$currentTipoCredito = this.getCurrentTipoCredito();
        ClassificacaoTipoTributo other$currentTipoCredito = other.getCurrentTipoCredito();
        return !(this$currentTipoCredito == null ? other$currentTipoCredito != null : !this$currentTipoCredito.equals(other$currentTipoCredito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InscricaoDividaAtivaValidacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTipoOperacaoCreditoValida() ? 79 : 97);
        Long $idTceInscCreditoDa = this.getIdTceInscCreditoDa();
        result = result * 59 + ($idTceInscCreditoDa == null ? 43 : ((Object)$idTceInscCreditoDa).hashCode());
        Long $nrAnoInscricao = this.getNrAnoInscricao();
        result = result * 59 + ($nrAnoInscricao == null ? 43 : ((Object)$nrAnoInscricao).hashCode());
        Long $idTipoOperacaoCredito = this.getIdTipoOperacaoCredito();
        result = result * 59 + ($idTipoOperacaoCredito == null ? 43 : ((Object)$idTipoOperacaoCredito).hashCode());
        Long $idTipoNaturezaCredito = this.getIdTipoNaturezaCredito();
        result = result * 59 + ($idTipoNaturezaCredito == null ? 43 : ((Object)$idTipoNaturezaCredito).hashCode());
        Integer $idTipoCredito = this.getIdTipoCredito();
        result = result * 59 + ($idTipoCredito == null ? 43 : ((Object)$idTipoCredito).hashCode());
        Long $nrDivida = this.getNrDivida();
        result = result * 59 + ($nrDivida == null ? 43 : ((Object)$nrDivida).hashCode());
        Long $nrAnoDivida = this.getNrAnoDivida();
        result = result * 59 + ($nrAnoDivida == null ? 43 : ((Object)$nrAnoDivida).hashCode());
        Long $nrCredito = this.getNrCredito();
        result = result * 59 + ($nrCredito == null ? 43 : ((Object)$nrCredito).hashCode());
        Long $nrAnoCredito = this.getNrAnoCredito();
        result = result * 59 + ($nrAnoCredito == null ? 43 : ((Object)$nrAnoCredito).hashCode());
        Long $nrAnoBase = this.getNrAnoBase();
        result = result * 59 + ($nrAnoBase == null ? 43 : ((Object)$nrAnoBase).hashCode());
        Long $nrMesBase = this.getNrMesBase();
        result = result * 59 + ($nrMesBase == null ? 43 : ((Object)$nrMesBase).hashCode());
        Long $quantidadeRegistroNrDivida = this.getQuantidadeRegistroNrDivida();
        result = result * 59 + ($quantidadeRegistroNrDivida == null ? 43 : ((Object)$quantidadeRegistroNrDivida).hashCode());
        Long $quantidadeRegistroCredito = this.getQuantidadeRegistroCredito();
        result = result * 59 + ($quantidadeRegistroCredito == null ? 43 : ((Object)$quantidadeRegistroCredito).hashCode());
        Long $escopoLei = this.getEscopoLei();
        result = result * 59 + ($escopoLei == null ? 43 : ((Object)$escopoLei).hashCode());
        Long $cdControleLeiAto = this.getCdControleLeiAto();
        result = result * 59 + ($cdControleLeiAto == null ? 43 : ((Object)$cdControleLeiAto).hashCode());
        Long $nrDividaAnterior = this.getNrDividaAnterior();
        result = result * 59 + ($nrDividaAnterior == null ? 43 : ((Object)$nrDividaAnterior).hashCode());
        LocalDate $dtInscricao = this.getDtInscricao();
        result = result * 59 + ($dtInscricao == null ? 43 : ((Object)$dtInscricao).hashCode());
        BigDecimal $vlInscricao = this.getVlInscricao();
        result = result * 59 + ($vlInscricao == null ? 43 : ((Object)$vlInscricao).hashCode());
        LocalDate $dtLancamento = this.getDtLancamento();
        result = result * 59 + ($dtLancamento == null ? 43 : ((Object)$dtLancamento).hashCode());
        TipoOperacaoCredito $currentTipoOperacaoCredito = this.getCurrentTipoOperacaoCredito();
        result = result * 59 + ($currentTipoOperacaoCredito == null ? 43 : $currentTipoOperacaoCredito.hashCode());
        TipoNaturezaCredito $currentTipoNaturezaCredito = this.getCurrentTipoNaturezaCredito();
        result = result * 59 + ($currentTipoNaturezaCredito == null ? 43 : $currentTipoNaturezaCredito.hashCode());
        ClassificacaoTipoTributo $currentTipoCredito = this.getCurrentTipoCredito();
        result = result * 59 + ($currentTipoCredito == null ? 43 : $currentTipoCredito.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InscricaoDividaAtivaValidacao(idTceInscCreditoDa=" + this.getIdTceInscCreditoDa() + ", nrAnoInscricao=" + this.getNrAnoInscricao() + ", dtInscricao=" + this.getDtInscricao() + ", vlInscricao=" + this.getVlInscricao() + ", idTipoOperacaoCredito=" + this.getIdTipoOperacaoCredito() + ", idTipoNaturezaCredito=" + this.getIdTipoNaturezaCredito() + ", idTipoCredito=" + this.getIdTipoCredito() + ", nrDivida=" + this.getNrDivida() + ", nrAnoDivida=" + this.getNrAnoDivida() + ", nrCredito=" + this.getNrCredito() + ", nrAnoCredito=" + this.getNrAnoCredito() + ", dtLancamento=" + this.getDtLancamento() + ", nrAnoBase=" + this.getNrAnoBase() + ", nrMesBase=" + this.getNrMesBase() + ", quantidadeRegistroNrDivida=" + this.getQuantidadeRegistroNrDivida() + ", quantidadeRegistroCredito=" + this.getQuantidadeRegistroCredito() + ", escopoLei=" + this.getEscopoLei() + ", cdControleLeiAto=" + this.getCdControleLeiAto() + ", nrDividaAnterior=" + this.getNrDividaAnterior() + ", currentTipoOperacaoCredito=" + this.getCurrentTipoOperacaoCredito() + ", currentTipoNaturezaCredito=" + this.getCurrentTipoNaturezaCredito() + ", currentTipoCredito=" + this.getCurrentTipoCredito() + ", isTipoOperacaoCreditoValida=" + this.isTipoOperacaoCreditoValida() + ")";
    }

    @Generated
    public InscricaoDividaAtivaValidacao() {
    }

    @Generated
    public InscricaoDividaAtivaValidacao(Long idTceInscCreditoDa, Long nrAnoInscricao, LocalDate dtInscricao, BigDecimal vlInscricao, Long idTipoOperacaoCredito, Long idTipoNaturezaCredito, Integer idTipoCredito, Long nrDivida, Long nrAnoDivida, Long nrCredito, Long nrAnoCredito, LocalDate dtLancamento, Long nrAnoBase, Long nrMesBase, Long quantidadeRegistroNrDivida, Long quantidadeRegistroCredito, Long escopoLei, Long cdControleLeiAto, Long nrDividaAnterior, TipoOperacaoCredito currentTipoOperacaoCredito, TipoNaturezaCredito currentTipoNaturezaCredito, ClassificacaoTipoTributo currentTipoCredito, boolean isTipoOperacaoCreditoValida) {
        this.idTceInscCreditoDa = idTceInscCreditoDa;
        this.nrAnoInscricao = nrAnoInscricao;
        this.dtInscricao = dtInscricao;
        this.vlInscricao = vlInscricao;
        this.idTipoOperacaoCredito = idTipoOperacaoCredito;
        this.idTipoNaturezaCredito = idTipoNaturezaCredito;
        this.idTipoCredito = idTipoCredito;
        this.nrDivida = nrDivida;
        this.nrAnoDivida = nrAnoDivida;
        this.nrCredito = nrCredito;
        this.nrAnoCredito = nrAnoCredito;
        this.dtLancamento = dtLancamento;
        this.nrAnoBase = nrAnoBase;
        this.nrMesBase = nrMesBase;
        this.quantidadeRegistroNrDivida = quantidadeRegistroNrDivida;
        this.quantidadeRegistroCredito = quantidadeRegistroCredito;
        this.escopoLei = escopoLei;
        this.cdControleLeiAto = cdControleLeiAto;
        this.nrDividaAnterior = nrDividaAnterior;
        this.currentTipoOperacaoCredito = currentTipoOperacaoCredito;
        this.currentTipoNaturezaCredito = currentTipoNaturezaCredito;
        this.currentTipoCredito = currentTipoCredito;
        this.isTipoOperacaoCreditoValida = isTipoOperacaoCreditoValida;
    }
}

