/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.simam.validacaoimportacao;

import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoInscricaoDividaAtivaValidacao;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class EstornoInscricaoDividaAtivaValidacao {
    private static final Long CODIGO_ESCOPO_LEI = 22L;
    private Long idTceInscCreditoDaEst;
    private Long nrEstorno;
    private Long nrAnoEstorno;
    private LocalDate dtEstorno;
    private BigDecimal vlEstorno;
    private Long nrDivida;
    private Long nrAnoDivida;
    private LocalDate dtInscricao;
    private String dsMotivo;
    private Long escopoLei;
    private Long qtdRegistroNrEstorno;
    private Long qtdRegistroEstornoRepetido;
    private Long nrEstornoAnterior;
    private Long cdControleLeiAto;

    public boolean isDuplicado() {
        return this.qtdRegistroNrEstorno > 1L;
    }

    public boolean isSequenciaValida() {
        return this.nrEstornoAnterior == 0L || this.nrEstorno - this.nrEstornoAnterior == 1L;
    }

    public boolean temDividaVinculada() {
        return this.nrDivida != null && this.nrAnoDivida != null;
    }

    public boolean isEscopoMunicipal() {
        return CODIGO_ESCOPO_LEI.equals(this.escopoLei);
    }

    public boolean isDataEstornoCorreto(LocalDate dataProcessamento) {
        return !this.dtEstorno.isBefore(this.dtInscricao) && !this.dtEstorno.isAfter(dataProcessamento);
    }

    public boolean isValorPositivo() {
        return this.vlEstorno.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isMotivoMaiorQueVinteCaracteres() {
        return this.dsMotivo.length() > 20;
    }

    public boolean existeEstornoRepetidoParaAInscricao() {
        return this.qtdRegistroEstornoRepetido > 1L;
    }

    public boolean isEstornoDeUmaInscricaoComDividaDoMesmoAnoDoProcessamento(LocalDate dataProcessamento) {
        return this.nrAnoEstorno == null || this.nrAnoDivida == null || this.nrAnoDivida == (long)dataProcessamento.getYear();
    }

    @Generated
    public static EstornoInscricaoDividaAtivaValidacaoBuilder builder() {
        return new EstornoInscricaoDividaAtivaValidacaoBuilder();
    }

    @Generated
    public Long getIdTceInscCreditoDaEst() {
        return this.idTceInscCreditoDaEst;
    }

    @Generated
    public Long getNrEstorno() {
        return this.nrEstorno;
    }

    @Generated
    public Long getNrAnoEstorno() {
        return this.nrAnoEstorno;
    }

    @Generated
    public LocalDate getDtEstorno() {
        return this.dtEstorno;
    }

    @Generated
    public BigDecimal getVlEstorno() {
        return this.vlEstorno;
    }

    @Generated
    public Long getNrDivida() {
        return this.nrDivida;
    }

    @Generated
    public Long getNrAnoDivida() {
        return this.nrAnoDivida;
    }

    @Generated
    public LocalDate getDtInscricao() {
        return this.dtInscricao;
    }

    @Generated
    public String getDsMotivo() {
        return this.dsMotivo;
    }

    @Generated
    public Long getEscopoLei() {
        return this.escopoLei;
    }

    @Generated
    public Long getQtdRegistroNrEstorno() {
        return this.qtdRegistroNrEstorno;
    }

    @Generated
    public Long getQtdRegistroEstornoRepetido() {
        return this.qtdRegistroEstornoRepetido;
    }

    @Generated
    public Long getNrEstornoAnterior() {
        return this.nrEstornoAnterior;
    }

    @Generated
    public Long getCdControleLeiAto() {
        return this.cdControleLeiAto;
    }

    @Generated
    public void setIdTceInscCreditoDaEst(Long idTceInscCreditoDaEst) {
        this.idTceInscCreditoDaEst = idTceInscCreditoDaEst;
    }

    @Generated
    public void setNrEstorno(Long nrEstorno) {
        this.nrEstorno = nrEstorno;
    }

    @Generated
    public void setNrAnoEstorno(Long nrAnoEstorno) {
        this.nrAnoEstorno = nrAnoEstorno;
    }

    @Generated
    public void setDtEstorno(LocalDate dtEstorno) {
        this.dtEstorno = dtEstorno;
    }

    @Generated
    public void setVlEstorno(BigDecimal vlEstorno) {
        this.vlEstorno = vlEstorno;
    }

    @Generated
    public void setNrDivida(Long nrDivida) {
        this.nrDivida = nrDivida;
    }

    @Generated
    public void setNrAnoDivida(Long nrAnoDivida) {
        this.nrAnoDivida = nrAnoDivida;
    }

    @Generated
    public void setDtInscricao(LocalDate dtInscricao) {
        this.dtInscricao = dtInscricao;
    }

    @Generated
    public void setDsMotivo(String dsMotivo) {
        this.dsMotivo = dsMotivo;
    }

    @Generated
    public void setEscopoLei(Long escopoLei) {
        this.escopoLei = escopoLei;
    }

    @Generated
    public void setQtdRegistroNrEstorno(Long qtdRegistroNrEstorno) {
        this.qtdRegistroNrEstorno = qtdRegistroNrEstorno;
    }

    @Generated
    public void setQtdRegistroEstornoRepetido(Long qtdRegistroEstornoRepetido) {
        this.qtdRegistroEstornoRepetido = qtdRegistroEstornoRepetido;
    }

    @Generated
    public void setNrEstornoAnterior(Long nrEstornoAnterior) {
        this.nrEstornoAnterior = nrEstornoAnterior;
    }

    @Generated
    public void setCdControleLeiAto(Long cdControleLeiAto) {
        this.cdControleLeiAto = cdControleLeiAto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstornoInscricaoDividaAtivaValidacao)) {
            return false;
        }
        EstornoInscricaoDividaAtivaValidacao other = (EstornoInscricaoDividaAtivaValidacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idTceInscCreditoDaEst = this.getIdTceInscCreditoDaEst();
        Long other$idTceInscCreditoDaEst = other.getIdTceInscCreditoDaEst();
        if (this$idTceInscCreditoDaEst == null ? other$idTceInscCreditoDaEst != null : !((Object)this$idTceInscCreditoDaEst).equals(other$idTceInscCreditoDaEst)) {
            return false;
        }
        Long this$nrEstorno = this.getNrEstorno();
        Long other$nrEstorno = other.getNrEstorno();
        if (this$nrEstorno == null ? other$nrEstorno != null : !((Object)this$nrEstorno).equals(other$nrEstorno)) {
            return false;
        }
        Long this$nrAnoEstorno = this.getNrAnoEstorno();
        Long other$nrAnoEstorno = other.getNrAnoEstorno();
        if (this$nrAnoEstorno == null ? other$nrAnoEstorno != null : !((Object)this$nrAnoEstorno).equals(other$nrAnoEstorno)) {
            return false;
        }
        Long this$nrDivida = this.getNrDivida();
        Long other$nrDivida = other.getNrDivida();
        if (this$nrDivida == null ? other$nrDivida != null : !((Object)this$nrDivida).equals(other$nrDivida)) {
            return false;
        }
        Long this$nrAnoDivida = this.getNrAnoDivida();
        Long other$nrAnoDivida = other.getNrAnoDivida();
        if (this$nrAnoDivida == null ? other$nrAnoDivida != null : !((Object)this$nrAnoDivida).equals(other$nrAnoDivida)) {
            return false;
        }
        Long this$escopoLei = this.getEscopoLei();
        Long other$escopoLei = other.getEscopoLei();
        if (this$escopoLei == null ? other$escopoLei != null : !((Object)this$escopoLei).equals(other$escopoLei)) {
            return false;
        }
        Long this$qtdRegistroNrEstorno = this.getQtdRegistroNrEstorno();
        Long other$qtdRegistroNrEstorno = other.getQtdRegistroNrEstorno();
        if (this$qtdRegistroNrEstorno == null ? other$qtdRegistroNrEstorno != null : !((Object)this$qtdRegistroNrEstorno).equals(other$qtdRegistroNrEstorno)) {
            return false;
        }
        Long this$qtdRegistroEstornoRepetido = this.getQtdRegistroEstornoRepetido();
        Long other$qtdRegistroEstornoRepetido = other.getQtdRegistroEstornoRepetido();
        if (this$qtdRegistroEstornoRepetido == null ? other$qtdRegistroEstornoRepetido != null : !((Object)this$qtdRegistroEstornoRepetido).equals(other$qtdRegistroEstornoRepetido)) {
            return false;
        }
        Long this$nrEstornoAnterior = this.getNrEstornoAnterior();
        Long other$nrEstornoAnterior = other.getNrEstornoAnterior();
        if (this$nrEstornoAnterior == null ? other$nrEstornoAnterior != null : !((Object)this$nrEstornoAnterior).equals(other$nrEstornoAnterior)) {
            return false;
        }
        Long this$cdControleLeiAto = this.getCdControleLeiAto();
        Long other$cdControleLeiAto = other.getCdControleLeiAto();
        if (this$cdControleLeiAto == null ? other$cdControleLeiAto != null : !((Object)this$cdControleLeiAto).equals(other$cdControleLeiAto)) {
            return false;
        }
        LocalDate this$dtEstorno = this.getDtEstorno();
        LocalDate other$dtEstorno = other.getDtEstorno();
        if (this$dtEstorno == null ? other$dtEstorno != null : !((Object)this$dtEstorno).equals(other$dtEstorno)) {
            return false;
        }
        BigDecimal this$vlEstorno = this.getVlEstorno();
        BigDecimal other$vlEstorno = other.getVlEstorno();
        if (this$vlEstorno == null ? other$vlEstorno != null : !((Object)this$vlEstorno).equals(other$vlEstorno)) {
            return false;
        }
        LocalDate this$dtInscricao = this.getDtInscricao();
        LocalDate other$dtInscricao = other.getDtInscricao();
        if (this$dtInscricao == null ? other$dtInscricao != null : !((Object)this$dtInscricao).equals(other$dtInscricao)) {
            return false;
        }
        String this$dsMotivo = this.getDsMotivo();
        String other$dsMotivo = other.getDsMotivo();
        return !(this$dsMotivo == null ? other$dsMotivo != null : !this$dsMotivo.equals(other$dsMotivo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EstornoInscricaoDividaAtivaValidacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idTceInscCreditoDaEst = this.getIdTceInscCreditoDaEst();
        result = result * 59 + ($idTceInscCreditoDaEst == null ? 43 : ((Object)$idTceInscCreditoDaEst).hashCode());
        Long $nrEstorno = this.getNrEstorno();
        result = result * 59 + ($nrEstorno == null ? 43 : ((Object)$nrEstorno).hashCode());
        Long $nrAnoEstorno = this.getNrAnoEstorno();
        result = result * 59 + ($nrAnoEstorno == null ? 43 : ((Object)$nrAnoEstorno).hashCode());
        Long $nrDivida = this.getNrDivida();
        result = result * 59 + ($nrDivida == null ? 43 : ((Object)$nrDivida).hashCode());
        Long $nrAnoDivida = this.getNrAnoDivida();
        result = result * 59 + ($nrAnoDivida == null ? 43 : ((Object)$nrAnoDivida).hashCode());
        Long $escopoLei = this.getEscopoLei();
        result = result * 59 + ($escopoLei == null ? 43 : ((Object)$escopoLei).hashCode());
        Long $qtdRegistroNrEstorno = this.getQtdRegistroNrEstorno();
        result = result * 59 + ($qtdRegistroNrEstorno == null ? 43 : ((Object)$qtdRegistroNrEstorno).hashCode());
        Long $qtdRegistroEstornoRepetido = this.getQtdRegistroEstornoRepetido();
        result = result * 59 + ($qtdRegistroEstornoRepetido == null ? 43 : ((Object)$qtdRegistroEstornoRepetido).hashCode());
        Long $nrEstornoAnterior = this.getNrEstornoAnterior();
        result = result * 59 + ($nrEstornoAnterior == null ? 43 : ((Object)$nrEstornoAnterior).hashCode());
        Long $cdControleLeiAto = this.getCdControleLeiAto();
        result = result * 59 + ($cdControleLeiAto == null ? 43 : ((Object)$cdControleLeiAto).hashCode());
        LocalDate $dtEstorno = this.getDtEstorno();
        result = result * 59 + ($dtEstorno == null ? 43 : ((Object)$dtEstorno).hashCode());
        BigDecimal $vlEstorno = this.getVlEstorno();
        result = result * 59 + ($vlEstorno == null ? 43 : ((Object)$vlEstorno).hashCode());
        LocalDate $dtInscricao = this.getDtInscricao();
        result = result * 59 + ($dtInscricao == null ? 43 : ((Object)$dtInscricao).hashCode());
        String $dsMotivo = this.getDsMotivo();
        result = result * 59 + ($dsMotivo == null ? 43 : $dsMotivo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EstornoInscricaoDividaAtivaValidacao(idTceInscCreditoDaEst=" + this.getIdTceInscCreditoDaEst() + ", nrEstorno=" + this.getNrEstorno() + ", nrAnoEstorno=" + this.getNrAnoEstorno() + ", dtEstorno=" + this.getDtEstorno() + ", vlEstorno=" + this.getVlEstorno() + ", nrDivida=" + this.getNrDivida() + ", nrAnoDivida=" + this.getNrAnoDivida() + ", dtInscricao=" + this.getDtInscricao() + ", dsMotivo=" + this.getDsMotivo() + ", escopoLei=" + this.getEscopoLei() + ", qtdRegistroNrEstorno=" + this.getQtdRegistroNrEstorno() + ", qtdRegistroEstornoRepetido=" + this.getQtdRegistroEstornoRepetido() + ", nrEstornoAnterior=" + this.getNrEstornoAnterior() + ", cdControleLeiAto=" + this.getCdControleLeiAto() + ")";
    }

    @Generated
    public EstornoInscricaoDividaAtivaValidacao() {
    }

    @Generated
    public EstornoInscricaoDividaAtivaValidacao(Long idTceInscCreditoDaEst, Long nrEstorno, Long nrAnoEstorno, LocalDate dtEstorno, BigDecimal vlEstorno, Long nrDivida, Long nrAnoDivida, LocalDate dtInscricao, String dsMotivo, Long escopoLei, Long qtdRegistroNrEstorno, Long qtdRegistroEstornoRepetido, Long nrEstornoAnterior, Long cdControleLeiAto) {
        this.idTceInscCreditoDaEst = idTceInscCreditoDaEst;
        this.nrEstorno = nrEstorno;
        this.nrAnoEstorno = nrAnoEstorno;
        this.dtEstorno = dtEstorno;
        this.vlEstorno = vlEstorno;
        this.nrDivida = nrDivida;
        this.nrAnoDivida = nrAnoDivida;
        this.dtInscricao = dtInscricao;
        this.dsMotivo = dsMotivo;
        this.escopoLei = escopoLei;
        this.qtdRegistroNrEstorno = qtdRegistroNrEstorno;
        this.qtdRegistroEstornoRepetido = qtdRegistroEstornoRepetido;
        this.nrEstornoAnterior = nrEstornoAnterior;
        this.cdControleLeiAto = cdControleLeiAto;
    }
}

