/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.enums.TipoConsultaSaldoSimAm;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.io.Serializable;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroConsultaSaldoDTO
implements Serializable {
    private String numeroCredito;
    private String numeroDivida;
    private String tipoCredito;
    @NotNull(message="O Tipo da Consulta precisa ser informado.")
    private @NotNull(message="O Tipo da Consulta precisa ser informado.") TipoConsultaSaldoSimAm tipoConsultaSaldo;
    @NotNull(message="A data inicial precisa ser informada.")
    private @NotNull(message="A data inicial precisa ser informada.") LocalDate dataInicial;
    @NotNull(message="A data final precisa ser informada.")
    private @NotNull(message="A data final precisa ser informada.") LocalDate dataFinal;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    public String buildFiltro() {
        StringBuilder filtro = new StringBuilder();
        if (this.tipoConsultaSaldo.equals((Object)TipoConsultaSaldoSimAm.CREDITO) && StringUtils.isNotBlank((CharSequence)this.numeroCredito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.numeroCredito, (String)"filtro.nrcredito")));
        }
        if (this.tipoConsultaSaldo.equals((Object)TipoConsultaSaldoSimAm.DIVIDA) && StringUtils.isNotBlank((CharSequence)this.numeroDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.numeroDivida, (String)"filtro.nrdivida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.tipoCredito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.tipoCredito, (String)"filtro.idTipoCredito")));
        }
        return filtro.toString();
    }

    public void validaDatas() {
        if (this.dataInicial.isAfter(this.dataFinal)) {
            throw new EloValidationException("Intervalo de datas inv\u00e1lido, favor corrija para prosseguir.");
        }
        if (this.dataInicial.isAfter(LocalDate.now())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel consultar uma compet\u00eancia maior que a atual.");
        }
    }

    @Generated
    public FiltroConsultaSaldoDTO() {
    }

    @Generated
    public String getNumeroCredito() {
        return this.numeroCredito;
    }

    @Generated
    public String getNumeroDivida() {
        return this.numeroDivida;
    }

    @Generated
    public String getTipoCredito() {
        return this.tipoCredito;
    }

    @Generated
    public TipoConsultaSaldoSimAm getTipoConsultaSaldo() {
        return this.tipoConsultaSaldo;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public void setNumeroCredito(String numeroCredito) {
        this.numeroCredito = numeroCredito;
    }

    @Generated
    public void setNumeroDivida(String numeroDivida) {
        this.numeroDivida = numeroDivida;
    }

    @Generated
    public void setTipoCredito(String tipoCredito) {
        this.tipoCredito = tipoCredito;
    }

    @Generated
    public void setTipoConsultaSaldo(TipoConsultaSaldoSimAm tipoConsultaSaldo) {
        this.tipoConsultaSaldo = tipoConsultaSaldo;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaSaldoDTO)) {
            return false;
        }
        FiltroConsultaSaldoDTO other = (FiltroConsultaSaldoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$numeroCredito = this.getNumeroCredito();
        String other$numeroCredito = other.getNumeroCredito();
        if (this$numeroCredito == null ? other$numeroCredito != null : !this$numeroCredito.equals(other$numeroCredito)) {
            return false;
        }
        String this$numeroDivida = this.getNumeroDivida();
        String other$numeroDivida = other.getNumeroDivida();
        if (this$numeroDivida == null ? other$numeroDivida != null : !this$numeroDivida.equals(other$numeroDivida)) {
            return false;
        }
        String this$tipoCredito = this.getTipoCredito();
        String other$tipoCredito = other.getTipoCredito();
        if (this$tipoCredito == null ? other$tipoCredito != null : !this$tipoCredito.equals(other$tipoCredito)) {
            return false;
        }
        TipoConsultaSaldoSimAm this$tipoConsultaSaldo = this.getTipoConsultaSaldo();
        TipoConsultaSaldoSimAm other$tipoConsultaSaldo = other.getTipoConsultaSaldo();
        if (this$tipoConsultaSaldo == null ? other$tipoConsultaSaldo != null : !this$tipoConsultaSaldo.equals(other$tipoConsultaSaldo)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        return !(this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaSaldoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $numeroCredito = this.getNumeroCredito();
        result = result * 59 + ($numeroCredito == null ? 43 : $numeroCredito.hashCode());
        String $numeroDivida = this.getNumeroDivida();
        result = result * 59 + ($numeroDivida == null ? 43 : $numeroDivida.hashCode());
        String $tipoCredito = this.getTipoCredito();
        result = result * 59 + ($tipoCredito == null ? 43 : $tipoCredito.hashCode());
        TipoConsultaSaldoSimAm $tipoConsultaSaldo = this.getTipoConsultaSaldo();
        result = result * 59 + ($tipoConsultaSaldo == null ? 43 : $tipoConsultaSaldo.hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaSaldoDTO(numeroCredito=" + this.getNumeroCredito() + ", numeroDivida=" + this.getNumeroDivida() + ", tipoCredito=" + this.getTipoCredito() + ", tipoConsultaSaldo=" + this.getTipoConsultaSaldo() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ")";
    }
}

