/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.sicredi.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.enums.TipoConvenioWebHook;
import br.com.elotech.tributos.dto.sicredi.dto.SicrediDadosWebHookDTO;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SicrediDadosWebHookDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SicrediDadosWebHookDTO.class);
    private TipoConvenioWebHook sicrediTipoConvenioWebHook;
    private String nossoNumero;
    private String dataReferencia;
    private String movimento;
    private String carteira;
    private String endToEndId;
    private String txid;
    private BigDecimal valor;
    private BigDecimal valorOriginal;
    private String infoPagador;

    public static List<SicrediDadosWebHookDTO> from(JsonNode jsonWebHook) {
        if (jsonWebHook.has(TipoConvenioWebHook.COBRANCA_SICREDI.getJsonTag())) {
            JsonNode eventoWebhook = jsonWebHook.get(TipoConvenioWebHook.COBRANCA_SICREDI.getJsonTag());
            log.warn("Vai Processar COBRANCA SICREDI");
            if (eventoWebhook != null && !eventoWebhook.asText().trim().isEmpty()) {
                log.warn("Entrou para Processar COBRANCA SICREDI");
                SicrediDadosWebHookDTO dados = SicrediDadosWebHookDTO.builder().sicrediTipoConvenioWebHook(TipoConvenioWebHook.COBRANCA_SICREDI).nossoNumero(SicrediDadosWebHookDTO.getString((JsonNode)jsonWebHook, (String)"nossoNumero")).valor(SicrediDadosWebHookDTO.getBigDecimal((JsonNode)jsonWebHook, (String)"valorLiquidacao")).dataReferencia(SicrediDadosWebHookDTO.getDataReferencia((JsonNode)jsonWebHook.get("dataEvento")).toString()).build();
                return Collections.singletonList(dados);
            }
        } else if (jsonWebHook.has(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()) && jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()).isArray() && !jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag()).isEmpty()) {
            ArrayList<SicrediDadosWebHookDTO> arrecadacoes = new ArrayList<SicrediDadosWebHookDTO>();
            JsonNode pixNode = jsonWebHook.get(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX.getJsonTag());
            log.warn("Vai Processar COBRANCA ARRECADACAO_INTEGRADA_PIX");
            for (JsonNode item : pixNode) {
                log.warn("Entrou para Processar ARRECADACAO_INTEGRADA_PIX");
                SicrediDadosWebHookDTO dados = SicrediDadosWebHookDTO.builder().sicrediTipoConvenioWebHook(TipoConvenioWebHook.ARRECADACAO_INTEGRADA_PIX).txid(SicrediDadosWebHookDTO.getString((JsonNode)item, (String)"txid")).endToEndId(SicrediDadosWebHookDTO.getString((JsonNode)item, (String)"endToEndId")).dataReferencia(SicrediDadosWebHookDTO.getString((JsonNode)item, (String)"horario")).valor(SicrediDadosWebHookDTO.getBigDecimal((JsonNode)item, (String)"valor")).build();
                arrecadacoes.add(dados);
            }
            return arrecadacoes;
        }
        throw new EloValidationException("Payload recebido pelo Sicredi n\u00e3o atende ao esperado");
    }

    private static String getString(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? jsonNode.get(campo).asText() : null;
    }

    private static BigDecimal getBigDecimal(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? new BigDecimal(jsonNode.get(campo).asText()) : null;
    }

    private static LocalDate getDataReferencia(JsonNode dataEventoNode) {
        if (dataEventoNode == null) {
            throw new EloValidationException("Campo Data Evento n\u00e3o encontrado no retorno do webHook.");
        }
        if (dataEventoNode.isArray() && dataEventoNode.size() >= 3) {
            int year = dataEventoNode.get(0).asInt();
            int month = dataEventoNode.get(1).asInt();
            int day = dataEventoNode.get(2).asInt();
            try {
                return LocalDate.of(year, month, day);
            }
            catch (DateTimeException e) {
                throw new EloValidationException("Data inv\u00e1lida recebida pelo WEBHOOK para a Data de Evento: " + year + "-" + month + "-" + day);
            }
        }
        throw new EloValidationException("Formato inv\u00e1lido para para a Data De Evento: " + dataEventoNode);
    }

    @Generated
    public static SicrediDadosWebHookDTOBuilder builder() {
        return new SicrediDadosWebHookDTOBuilder();
    }

    @Generated
    public TipoConvenioWebHook getSicrediTipoConvenioWebHook() {
        return this.sicrediTipoConvenioWebHook;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public String getMovimento() {
        return this.movimento;
    }

    @Generated
    public String getCarteira() {
        return this.carteira;
    }

    @Generated
    public String getEndToEndId() {
        return this.endToEndId;
    }

    @Generated
    public String getTxid() {
        return this.txid;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public String getInfoPagador() {
        return this.infoPagador;
    }

    @Generated
    public SicrediDadosWebHookDTO(TipoConvenioWebHook sicrediTipoConvenioWebHook, String nossoNumero, String dataReferencia, String movimento, String carteira, String endToEndId, String txid, BigDecimal valor, BigDecimal valorOriginal, String infoPagador) {
        this.sicrediTipoConvenioWebHook = sicrediTipoConvenioWebHook;
        this.nossoNumero = nossoNumero;
        this.dataReferencia = dataReferencia;
        this.movimento = movimento;
        this.carteira = carteira;
        this.endToEndId = endToEndId;
        this.txid = txid;
        this.valor = valor;
        this.valorOriginal = valorOriginal;
        this.infoPagador = infoPagador;
    }

    @Generated
    public SicrediDadosWebHookDTO() {
    }
}

