/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.rol;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.rol.Rol;
import br.com.elotech.tributos.dto.rol.RolSituacaoDebito;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class GeraRolDTO {
    @NotNull(message="A data de refer\u00eancia deve ser informada")
    private @NotNull(message="A data de refer\u00eancia deve ser informada") LocalDate dataReferencia;
    private TipoCadastro tipoCadastro;
    private String cadastroGeral;
    private String anoDivida;
    private String divida;
    private String subDivida;
    private String tributo;
    private String observacao;
    private RolSituacaoDebito situacaoDebito;
    private List<Long> ignorarIntervaloDividas;
    private Long idRol;
    private Boolean calcularAcrescimos = Boolean.TRUE;
    private static final String AND = " and ";
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String TRIBUTO_PARAM = "tributo";
    private static final String IGNORAR_INTERVALO_DIVIDAS = "ignorarIntervaloDividas";
    private static final String ID_ROL = "idRol";
    private static final String SITUACAO_LEGAL = "situacaoLegal";
    private static final String DATA_LIMITE_VENCIMENTO = "dataLimiteVencimento";

    public boolean calcularAcrescimos() {
        return Boolean.TRUE.equals(this.calcularAcrescimos);
    }

    public Rol toEntity() {
        Rol rol = new Rol();
        rol.setExercicio(Long.valueOf(this.dataReferencia.getYear()));
        rol.setDataInicio(LocalDate.now());
        rol.setDescricao(this.observacao);
        rol.setUsuario(SecurityUtils.getUserAise());
        return rol;
    }

    public String buildWhereOnlyDebito() {
        StringBuilder where = new StringBuilder();
        this.appendTipoCadastro(where);
        this.appendCadastroGeral(where);
        this.appendAnoDivida(where);
        this.appendDivida(where);
        this.appendSubDivida(where);
        this.appendIgnorarIntervaloDividas(where);
        return where.toString();
    }

    public String buildWhere() {
        StringBuilder where = new StringBuilder(this.buildWhereOnlyDebito());
        this.appendTributo(where);
        return where.toString();
    }

    public MapSqlParameterSource buildParams() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addValueTipoCadastro(params);
        this.addValueTributo(params);
        this.addValueIgnorarIntervaloDividas(params);
        this.addValueIdRol(params);
        this.addValueSituacaoLegal(params);
        this.addValueDataLimiteVencimento(params);
        return params;
    }

    private String addAnd(String clause) {
        return AND + clause;
    }

    private void appendTipoCadastro(StringBuilder where) {
        if (Objects.isNull(this.tipoCadastro)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebito.tipocadastro = :%s", TIPO_CADASTRO)));
    }

    private void appendCadastroGeral(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.cadastroGeral)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tribdebito.cadastrogeral")));
    }

    private void appendAnoDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.anoDivida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.anoDivida, (String)"tribdebito.exercicio")));
    }

    private void appendDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.divida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.divida, (String)"tribdebito.guiarecolhimento")));
    }

    private void appendSubDivida(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.subDivida)) {
            return;
        }
        where.append(this.addAnd(MultiValueFilter.generateFilters((String)this.subDivida, (String)"tribdebito.subdivida")));
    }

    private void appendTributo(StringBuilder where) {
        if (StringUtils.isBlank((CharSequence)this.tributo)) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebitoparcelareceita.receita = :%s", TRIBUTO_PARAM)));
    }

    private void appendIgnorarIntervaloDividas(StringBuilder where) {
        if (Objects.isNull(this.ignorarIntervaloDividas) || this.ignorarIntervaloDividas.isEmpty()) {
            return;
        }
        where.append(this.addAnd(String.format("tribdebito.guiarecolhimento not in (:%s)", IGNORAR_INTERVALO_DIVIDAS)));
    }

    private void addValueTipoCadastro(MapSqlParameterSource params) {
        if (Objects.isNull(this.tipoCadastro)) {
            return;
        }
        params.addValue(TIPO_CADASTRO, (Object)this.tipoCadastro.getValue());
    }

    private void addValueTributo(MapSqlParameterSource params) {
        if (StringUtils.isBlank((CharSequence)this.tributo)) {
            return;
        }
        params.addValue(TRIBUTO_PARAM, (Object)this.tributo);
    }

    private void addValueIgnorarIntervaloDividas(MapSqlParameterSource params) {
        if (Objects.isNull(this.ignorarIntervaloDividas) || this.ignorarIntervaloDividas.isEmpty()) {
            return;
        }
        params.addValue(IGNORAR_INTERVALO_DIVIDAS, (Object)this.ignorarIntervaloDividas);
    }

    private void addValueSituacaoLegal(MapSqlParameterSource params) {
        if (Objects.isNull(this.situacaoDebito)) {
            params.addValue(SITUACAO_LEGAL, (Object)RolSituacaoDebito.TODOS);
            return;
        }
        params.addValue(SITUACAO_LEGAL, (Object)this.situacaoDebito.getValues());
    }

    private void addValueDataLimiteVencimento(MapSqlParameterSource params) {
        params.addValue(DATA_LIMITE_VENCIMENTO, (Object)this.dataReferencia);
    }

    private void addValueIdRol(MapSqlParameterSource params) {
        params.addValue(ID_ROL, (Object)this.idRol);
    }

    @Generated
    public GeraRolDTO() {
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDivida() {
        return this.anoDivida;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public RolSituacaoDebito getSituacaoDebito() {
        return this.situacaoDebito;
    }

    @Generated
    public List<Long> getIgnorarIntervaloDividas() {
        return this.ignorarIntervaloDividas;
    }

    @Generated
    public Long getIdRol() {
        return this.idRol;
    }

    @Generated
    public Boolean getCalcularAcrescimos() {
        return this.calcularAcrescimos;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDivida(String anoDivida) {
        this.anoDivida = anoDivida;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setSituacaoDebito(RolSituacaoDebito situacaoDebito) {
        this.situacaoDebito = situacaoDebito;
    }

    @Generated
    public void setIgnorarIntervaloDividas(List<Long> ignorarIntervaloDividas) {
        this.ignorarIntervaloDividas = ignorarIntervaloDividas;
    }

    @Generated
    public void setIdRol(Long idRol) {
        this.idRol = idRol;
    }

    @Generated
    public void setCalcularAcrescimos(Boolean calcularAcrescimos) {
        this.calcularAcrescimos = calcularAcrescimos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeraRolDTO)) {
            return false;
        }
        GeraRolDTO other = (GeraRolDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idRol = this.getIdRol();
        Long other$idRol = other.getIdRol();
        if (this$idRol == null ? other$idRol != null : !((Object)this$idRol).equals(other$idRol)) {
            return false;
        }
        Boolean this$calcularAcrescimos = this.getCalcularAcrescimos();
        Boolean other$calcularAcrescimos = other.getCalcularAcrescimos();
        if (this$calcularAcrescimos == null ? other$calcularAcrescimos != null : !((Object)this$calcularAcrescimos).equals(other$calcularAcrescimos)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDivida = this.getAnoDivida();
        String other$anoDivida = other.getAnoDivida();
        if (this$anoDivida == null ? other$anoDivida != null : !this$anoDivida.equals(other$anoDivida)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        RolSituacaoDebito this$situacaoDebito = this.getSituacaoDebito();
        RolSituacaoDebito other$situacaoDebito = other.getSituacaoDebito();
        if (this$situacaoDebito == null ? other$situacaoDebito != null : !this$situacaoDebito.equals(other$situacaoDebito)) {
            return false;
        }
        List this$ignorarIntervaloDividas = this.getIgnorarIntervaloDividas();
        List other$ignorarIntervaloDividas = other.getIgnorarIntervaloDividas();
        return !(this$ignorarIntervaloDividas == null ? other$ignorarIntervaloDividas != null : !((Object)this$ignorarIntervaloDividas).equals(other$ignorarIntervaloDividas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeraRolDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idRol = this.getIdRol();
        result = result * 59 + ($idRol == null ? 43 : ((Object)$idRol).hashCode());
        Boolean $calcularAcrescimos = this.getCalcularAcrescimos();
        result = result * 59 + ($calcularAcrescimos == null ? 43 : ((Object)$calcularAcrescimos).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDivida = this.getAnoDivida();
        result = result * 59 + ($anoDivida == null ? 43 : $anoDivida.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        RolSituacaoDebito $situacaoDebito = this.getSituacaoDebito();
        result = result * 59 + ($situacaoDebito == null ? 43 : $situacaoDebito.hashCode());
        List $ignorarIntervaloDividas = this.getIgnorarIntervaloDividas();
        result = result * 59 + ($ignorarIntervaloDividas == null ? 43 : ((Object)$ignorarIntervaloDividas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeraRolDTO(dataReferencia=" + this.getDataReferencia() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDivida=" + this.getAnoDivida() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", tributo=" + this.getTributo() + ", observacao=" + this.getObservacao() + ", situacaoDebito=" + this.getSituacaoDebito() + ", ignorarIntervaloDividas=" + this.getIgnorarIntervaloDividas() + ", idRol=" + this.getIdRol() + ", calcularAcrescimos=" + this.getCalcularAcrescimos() + ")";
    }
}

