/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.core.utils.ListUtils;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDTO;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroEstornoParcelamentoEmLoteDTO {
    private static final String AND = " and ";
    private static final String PARAM_ENTIDADE = "entidade";
    private static final String PARAM_DATA_INCLUSAO_INICIAL = "DataInclusaoInicial";
    private static final String PARAM_DATA_INCLUSAO_FINAL = "DataInclusaoFinal";
    private static final String PARAM_DATA_VENCIMENTO = "DataVencimento";
    private static final String PARAM_TIPO_CONTRATO = "tipoContrato";
    private static final String PARAM_TIPO_CADASTRO = "tipoCadastro";
    private static final String PARAM_SITUACAO_LEGAL = "situacaoLegal";
    private static final String PARAM_DATA_VENCIMENTO_BY_QTDE_DIAS = "dataVencimentoByQtdeDias";
    private static final String PARAM_DATA_VENCIMENTO_BY_NOVENTA_DIAS = "dataVencimentoByNoventaDias";
    private static final Long NOVENTA_DIAS = 90L;
    private LocalDate dataDoInicioDoParcelamento;
    private LocalDate dataDoFimDoParcelamento;
    private LocalDate vencimentoParcela;
    private Boolean parcelaVencidaNoventaDias;
    private Boolean boletosAVencer;
    private Boolean estornaOrigem;
    private String motivo;
    private String tipoContrato;
    private String numeroContrato;
    private String anoContrato;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicio;
    private String divida;
    private Long situacaoLegal;
    private Long qtdeDiasParcelasVencidas;
    private List<ParcelamentoDTO> filtroParamParcelamento;

    public String buildFiltroEstornoParcelamentoEmLoteDTO() {
        StringBuilder filtro = new StringBuilder();
        this.appendDataVencimentoParcela(filtro);
        this.appendDataParcelamentoInicial(filtro);
        this.appendDataParcelamentoFinal(filtro);
        this.appendIdParametroParcelamento(filtro);
        this.appendTipoContrato(filtro);
        this.appendNumeroContrato(filtro);
        this.appendAnoContrato(filtro);
        this.appendTipoCadastro(filtro);
        this.appendCadastroGeral(filtro);
        this.appendExercicio(filtro);
        this.appendDivida(filtro);
        this.appendSituacaoLegal(filtro);
        this.appendBoletosAVencer(filtro);
        this.appendQtdeDiasParcelasVencidas(filtro);
        this.appendParcelaVencidaNoventaDias(filtro);
        return filtro.toString();
    }

    public MapSqlParameterSource getParameterSource(Long entidade) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addValueEntidade(params, entidade);
        this.addValueDataInclusaoInicial(params);
        this.addValueDataInclusaoFinal(params);
        this.addValueDataVencimentoParcela(params);
        this.addValueTipoContrato(params);
        this.addValueTipoCadastro(params);
        this.addValueSituacaoLegal(params);
        this.addValueQtdeDiasParcelasVencidas(params);
        this.addValueParcelaVencidaNoventaDias(params);
        return params;
    }

    private String addAnd(String filtro) {
        return AND + filtro;
    }

    private void appendDataVencimentoParcela(StringBuilder filtro) {
        if (Objects.nonNull(this.vencimentoParcela)) {
            filtro.append(this.addAnd(String.format("tribdebitoparcela.datavencimento <= :%s", PARAM_DATA_VENCIMENTO)));
        }
    }

    private void appendDataParcelamentoInicial(StringBuilder filtro) {
        if (Objects.nonNull(this.dataDoInicioDoParcelamento)) {
            filtro.append(this.addAnd(String.format("tribparcelamento.dataparcelamento >= :%s", PARAM_DATA_INCLUSAO_INICIAL)));
        }
    }

    private void appendDataParcelamentoFinal(StringBuilder filtro) {
        if (Objects.nonNull(this.dataDoFimDoParcelamento)) {
            filtro.append(this.addAnd(String.format("tribparcelamento.dataparcelamento <= :%s", PARAM_DATA_INCLUSAO_FINAL)));
        }
    }

    private void appendIdParametroParcelamento(StringBuilder filtro) {
        if (Boolean.FALSE.equals(ListUtils.safeIsEmpty((List)this.filtroParamParcelamento))) {
            filtro.append(this.addAnd(String.format("(%s)", this.filtroParamParcelamento.stream().map(pp -> String.format("(tribparcelamento.idparametroparcelamento = %d)", pp.getId())).collect(Collectors.joining(" or ")))));
        }
    }

    private void appendTipoContrato(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.tipoContrato)) {
            filtro.append(this.addAnd(String.format("tribparcelamento.tipo = :%s", PARAM_TIPO_CONTRATO)));
        }
    }

    private void appendNumeroContrato(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.numeroContrato)) {
            filtro.append(this.addAnd(MultiValueFilter.generateFilters((String)this.numeroContrato, (String)"tribparcelamento.numerocontrato")));
        }
    }

    private void appendAnoContrato(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.anoContrato)) {
            filtro.append(this.addAnd(MultiValueFilter.generateFilters((String)this.anoContrato, (String)"tribparcelamento.anocontrato")));
        }
    }

    private void appendTipoCadastro(StringBuilder filtro) {
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAnd(String.format("tribparcelamento.tipocadastro = :%s", PARAM_TIPO_CADASTRO)));
        }
    }

    private void appendCadastroGeral(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAnd(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tribparcelamento.cadastrogeral")));
        }
    }

    private void appendExercicio(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.exercicio)) {
            filtro.append(this.addAnd(MultiValueFilter.generateFilters((String)this.exercicio, (String)"tribdebito.exercicio")));
        }
    }

    private void appendDivida(StringBuilder filtro) {
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAnd(MultiValueFilter.generateFilters((String)this.divida, (String)"tribdebito.guiarecolhimento")));
        }
    }

    private void appendSituacaoLegal(StringBuilder filtro) {
        if (Objects.nonNull(this.situacaoLegal)) {
            filtro.append(this.addAnd(String.format("tribdebitoparcela.situacaolegal = :%s", PARAM_SITUACAO_LEGAL)));
        }
    }

    private void appendBoletosAVencer(StringBuilder filtro) {
        if (Boolean.TRUE.equals(this.boletosAVencer)) {
            filtro.append(this.addAnd(String.format("(select count(distinct b.bloqueto) as total from tribparcelamentodebitoorigem tribparcelamentodebitoorigem left join tribdebito tribdebito on tribdebito.iddebito = tribparcelamentodebitoorigem.iddebitonovo left join tribdebitoparcelareceita dpr on tribdebito.entidade = dpr.entidade and tribdebito.exercicio = dpr.exercicio and tribdebito.tipocadastro = dpr.tipocadastro and tribdebito.cadastrogeral = dpr.cadastrogeral and tribdebito.guiarecolhimento = dpr.guiarecolhimento and tribdebito.subdivida = dpr.subdivida left join tribbloquetodebito bd on dpr.iddebitoparcelareceita = bd.iddebitoparcelareceita left join tribbloqueto b on bd.entidade = b.entidade and bd.exerciciobloqueto = b.exerciciobloqueto and bd.bloqueto = b.bloqueto where b.entidade = :%s and b.datavencimento >= cast(now() as date) and tribparcelamentodebitoorigem.idparcelamento = tribparcelamento.idparcelamento) > 0", PARAM_ENTIDADE)));
        }
    }

    private void appendQtdeDiasParcelasVencidas(StringBuilder filtro) {
        if (Objects.nonNull(this.qtdeDiasParcelasVencidas)) {
            filtro.append(this.addAnd(String.format("(tribdebitoparcela.datavencimento < cast(now() as date) and tribdebitoparcela.datavencimento >= :%s)", PARAM_DATA_VENCIMENTO_BY_QTDE_DIAS)));
        }
    }

    private void appendParcelaVencidaNoventaDias(StringBuilder filtro) {
        if (!Boolean.TRUE.equals(this.parcelaVencidaNoventaDias)) {
            filtro.append(this.addAnd(String.format("tribdebitoparcela.datavencimento >= :%s", PARAM_DATA_VENCIMENTO_BY_NOVENTA_DIAS)));
        }
    }

    private void addValueEntidade(MapSqlParameterSource params, Long entidade) {
        params.addValue(PARAM_ENTIDADE, (Object)entidade);
    }

    private void addValueDataInclusaoInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.getDataDoInicioDoParcelamento())) {
            params.addValue(PARAM_DATA_INCLUSAO_INICIAL, (Object)Date.valueOf(this.getDataDoInicioDoParcelamento()));
        }
    }

    private void addValueDataInclusaoFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.getDataDoFimDoParcelamento())) {
            params.addValue(PARAM_DATA_INCLUSAO_FINAL, (Object)Date.valueOf(this.getDataDoFimDoParcelamento()));
        }
    }

    private void addValueDataVencimentoParcela(MapSqlParameterSource params) {
        if (Objects.nonNull(this.getVencimentoParcela())) {
            params.addValue(PARAM_DATA_VENCIMENTO, (Object)Date.valueOf(this.getVencimentoParcela()));
        }
    }

    private void addValueTipoContrato(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoContrato)) {
            params.addValue(PARAM_TIPO_CONTRATO, (Object)this.tipoContrato);
        }
    }

    private void addValueTipoCadastro(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoCadastro)) {
            params.addValue(PARAM_TIPO_CADASTRO, (Object)this.tipoCadastro);
        }
    }

    private void addValueSituacaoLegal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.situacaoLegal)) {
            params.addValue(PARAM_SITUACAO_LEGAL, (Object)this.situacaoLegal);
        }
    }

    private void addValueQtdeDiasParcelasVencidas(MapSqlParameterSource params) {
        if (Objects.nonNull(this.qtdeDiasParcelasVencidas)) {
            LocalDate hojeMenosDias = LocalDate.now().minusDays(this.qtdeDiasParcelasVencidas);
            params.addValue(PARAM_DATA_VENCIMENTO_BY_QTDE_DIAS, (Object)Date.valueOf(hojeMenosDias));
        }
    }

    private void addValueParcelaVencidaNoventaDias(MapSqlParameterSource params) {
        if (!Boolean.TRUE.equals(this.parcelaVencidaNoventaDias)) {
            LocalDate hojeMenosNoventaDias = LocalDate.now().minusDays(NOVENTA_DIAS);
            params.addValue(PARAM_DATA_VENCIMENTO_BY_NOVENTA_DIAS, (Object)Date.valueOf(hojeMenosNoventaDias));
        }
    }

    @Generated
    public FiltroEstornoParcelamentoEmLoteDTO() {
    }

    @Generated
    public LocalDate getDataDoInicioDoParcelamento() {
        return this.dataDoInicioDoParcelamento;
    }

    @Generated
    public LocalDate getDataDoFimDoParcelamento() {
        return this.dataDoFimDoParcelamento;
    }

    @Generated
    public LocalDate getVencimentoParcela() {
        return this.vencimentoParcela;
    }

    @Generated
    public Boolean getParcelaVencidaNoventaDias() {
        return this.parcelaVencidaNoventaDias;
    }

    @Generated
    public Boolean getBoletosAVencer() {
        return this.boletosAVencer;
    }

    @Generated
    public Boolean getEstornaOrigem() {
        return this.estornaOrigem;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public String getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public String getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getQtdeDiasParcelasVencidas() {
        return this.qtdeDiasParcelasVencidas;
    }

    @Generated
    public List<ParcelamentoDTO> getFiltroParamParcelamento() {
        return this.filtroParamParcelamento;
    }

    @Generated
    public void setDataDoInicioDoParcelamento(LocalDate dataDoInicioDoParcelamento) {
        this.dataDoInicioDoParcelamento = dataDoInicioDoParcelamento;
    }

    @Generated
    public void setDataDoFimDoParcelamento(LocalDate dataDoFimDoParcelamento) {
        this.dataDoFimDoParcelamento = dataDoFimDoParcelamento;
    }

    @Generated
    public void setVencimentoParcela(LocalDate vencimentoParcela) {
        this.vencimentoParcela = vencimentoParcela;
    }

    @Generated
    public void setParcelaVencidaNoventaDias(Boolean parcelaVencidaNoventaDias) {
        this.parcelaVencidaNoventaDias = parcelaVencidaNoventaDias;
    }

    @Generated
    public void setBoletosAVencer(Boolean boletosAVencer) {
        this.boletosAVencer = boletosAVencer;
    }

    @Generated
    public void setEstornaOrigem(Boolean estornaOrigem) {
        this.estornaOrigem = estornaOrigem;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setNumeroContrato(String numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setAnoContrato(String anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setQtdeDiasParcelasVencidas(Long qtdeDiasParcelasVencidas) {
        this.qtdeDiasParcelasVencidas = qtdeDiasParcelasVencidas;
    }

    @Generated
    public void setFiltroParamParcelamento(List<ParcelamentoDTO> filtroParamParcelamento) {
        this.filtroParamParcelamento = filtroParamParcelamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroEstornoParcelamentoEmLoteDTO)) {
            return false;
        }
        FiltroEstornoParcelamentoEmLoteDTO other = (FiltroEstornoParcelamentoEmLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$parcelaVencidaNoventaDias = this.getParcelaVencidaNoventaDias();
        Boolean other$parcelaVencidaNoventaDias = other.getParcelaVencidaNoventaDias();
        if (this$parcelaVencidaNoventaDias == null ? other$parcelaVencidaNoventaDias != null : !((Object)this$parcelaVencidaNoventaDias).equals(other$parcelaVencidaNoventaDias)) {
            return false;
        }
        Boolean this$boletosAVencer = this.getBoletosAVencer();
        Boolean other$boletosAVencer = other.getBoletosAVencer();
        if (this$boletosAVencer == null ? other$boletosAVencer != null : !((Object)this$boletosAVencer).equals(other$boletosAVencer)) {
            return false;
        }
        Boolean this$estornaOrigem = this.getEstornaOrigem();
        Boolean other$estornaOrigem = other.getEstornaOrigem();
        if (this$estornaOrigem == null ? other$estornaOrigem != null : !((Object)this$estornaOrigem).equals(other$estornaOrigem)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$qtdeDiasParcelasVencidas = this.getQtdeDiasParcelasVencidas();
        Long other$qtdeDiasParcelasVencidas = other.getQtdeDiasParcelasVencidas();
        if (this$qtdeDiasParcelasVencidas == null ? other$qtdeDiasParcelasVencidas != null : !((Object)this$qtdeDiasParcelasVencidas).equals(other$qtdeDiasParcelasVencidas)) {
            return false;
        }
        LocalDate this$dataDoInicioDoParcelamento = this.getDataDoInicioDoParcelamento();
        LocalDate other$dataDoInicioDoParcelamento = other.getDataDoInicioDoParcelamento();
        if (this$dataDoInicioDoParcelamento == null ? other$dataDoInicioDoParcelamento != null : !((Object)this$dataDoInicioDoParcelamento).equals(other$dataDoInicioDoParcelamento)) {
            return false;
        }
        LocalDate this$dataDoFimDoParcelamento = this.getDataDoFimDoParcelamento();
        LocalDate other$dataDoFimDoParcelamento = other.getDataDoFimDoParcelamento();
        if (this$dataDoFimDoParcelamento == null ? other$dataDoFimDoParcelamento != null : !((Object)this$dataDoFimDoParcelamento).equals(other$dataDoFimDoParcelamento)) {
            return false;
        }
        LocalDate this$vencimentoParcela = this.getVencimentoParcela();
        LocalDate other$vencimentoParcela = other.getVencimentoParcela();
        if (this$vencimentoParcela == null ? other$vencimentoParcela != null : !((Object)this$vencimentoParcela).equals(other$vencimentoParcela)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        String this$numeroContrato = this.getNumeroContrato();
        String other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !this$numeroContrato.equals(other$numeroContrato)) {
            return false;
        }
        String this$anoContrato = this.getAnoContrato();
        String other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !this$anoContrato.equals(other$anoContrato)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        List this$filtroParamParcelamento = this.getFiltroParamParcelamento();
        List other$filtroParamParcelamento = other.getFiltroParamParcelamento();
        return !(this$filtroParamParcelamento == null ? other$filtroParamParcelamento != null : !((Object)this$filtroParamParcelamento).equals(other$filtroParamParcelamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroEstornoParcelamentoEmLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $parcelaVencidaNoventaDias = this.getParcelaVencidaNoventaDias();
        result = result * 59 + ($parcelaVencidaNoventaDias == null ? 43 : ((Object)$parcelaVencidaNoventaDias).hashCode());
        Boolean $boletosAVencer = this.getBoletosAVencer();
        result = result * 59 + ($boletosAVencer == null ? 43 : ((Object)$boletosAVencer).hashCode());
        Boolean $estornaOrigem = this.getEstornaOrigem();
        result = result * 59 + ($estornaOrigem == null ? 43 : ((Object)$estornaOrigem).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $qtdeDiasParcelasVencidas = this.getQtdeDiasParcelasVencidas();
        result = result * 59 + ($qtdeDiasParcelasVencidas == null ? 43 : ((Object)$qtdeDiasParcelasVencidas).hashCode());
        LocalDate $dataDoInicioDoParcelamento = this.getDataDoInicioDoParcelamento();
        result = result * 59 + ($dataDoInicioDoParcelamento == null ? 43 : ((Object)$dataDoInicioDoParcelamento).hashCode());
        LocalDate $dataDoFimDoParcelamento = this.getDataDoFimDoParcelamento();
        result = result * 59 + ($dataDoFimDoParcelamento == null ? 43 : ((Object)$dataDoFimDoParcelamento).hashCode());
        LocalDate $vencimentoParcela = this.getVencimentoParcela();
        result = result * 59 + ($vencimentoParcela == null ? 43 : ((Object)$vencimentoParcela).hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        String $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : $numeroContrato.hashCode());
        String $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : $anoContrato.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        List $filtroParamParcelamento = this.getFiltroParamParcelamento();
        result = result * 59 + ($filtroParamParcelamento == null ? 43 : ((Object)$filtroParamParcelamento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroEstornoParcelamentoEmLoteDTO(dataDoInicioDoParcelamento=" + this.getDataDoInicioDoParcelamento() + ", dataDoFimDoParcelamento=" + this.getDataDoFimDoParcelamento() + ", vencimentoParcela=" + this.getVencimentoParcela() + ", parcelaVencidaNoventaDias=" + this.getParcelaVencidaNoventaDias() + ", boletosAVencer=" + this.getBoletosAVencer() + ", estornaOrigem=" + this.getEstornaOrigem() + ", motivo=" + this.getMotivo() + ", tipoContrato=" + this.getTipoContrato() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", situacaoLegal=" + this.getSituacaoLegal() + ", qtdeDiasParcelasVencidas=" + this.getQtdeDiasParcelasVencidas() + ", filtroParamParcelamento=" + this.getFiltroParamParcelamento() + ")";
    }
}

